/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorstorage.definition;

import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordField;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorStoreRecordDataField
extends VectorStoreRecordField {
    private final boolean isFilterable;
    private final boolean isFullTextSearchable;

    public static Builder builder() {
        return new Builder();
    }

    public VectorStoreRecordDataField(@Nonnull String name, @Nullable String storageName, @Nonnull Class<?> fieldType, boolean isFilterable, boolean isFullTextSearchable) {
        super(name, storageName, fieldType);
        this.isFilterable = isFilterable;
        this.isFullTextSearchable = isFullTextSearchable;
    }

    public boolean isFilterable() {
        return this.isFilterable;
    }

    public boolean isFullTextSearchable() {
        return this.isFullTextSearchable;
    }

    public static class Builder
    extends VectorStoreRecordField.Builder<VectorStoreRecordDataField, Builder> {
        private boolean isFilterable;
        private boolean isFullTextSearchable;

        public Builder isFilterable(boolean isFilterable) {
            this.isFilterable = isFilterable;
            return this;
        }

        public Builder isFullTextSearchable(boolean isFullTextSearchable) {
            this.isFullTextSearchable = isFullTextSearchable;
            return this;
        }

        @Override
        public VectorStoreRecordDataField build() {
            if (this.name == null) {
                throw new IllegalArgumentException("name is required");
            }
            if (this.fieldType == null) {
                throw new IllegalArgumentException("fieldType is required");
            }
            return new VectorStoreRecordDataField(this.name, this.storageName, this.fieldType, this.isFilterable, this.isFullTextSearchable);
        }
    }
}

