/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.semantickernel.data.VolatileVectorStoreCollectionSearchMapping;
import com.microsoft.semantickernel.data.VolatileVectorStoreRecordCollectionOptions;
import com.microsoft.semantickernel.data.vectorsearch.VectorOperations;
import com.microsoft.semantickernel.data.vectorsearch.VectorSearchResults;
import com.microsoft.semantickernel.data.vectorstorage.VectorStoreRecordCollection;
import com.microsoft.semantickernel.data.vectorstorage.definition.DistanceFunction;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordDefinition;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordVectorField;
import com.microsoft.semantickernel.data.vectorstorage.options.DeleteRecordOptions;
import com.microsoft.semantickernel.data.vectorstorage.options.GetRecordOptions;
import com.microsoft.semantickernel.data.vectorstorage.options.UpsertRecordOptions;
import com.microsoft.semantickernel.data.vectorstorage.options.VectorSearchOptions;
import com.microsoft.semantickernel.exceptions.SKException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class VolatileVectorStoreRecordCollection<Record>
implements VectorStoreRecordCollection<String, Record> {
    private static final HashSet<Class<?>> supportedKeyTypes = new HashSet<Class<String>>(Collections.singletonList(String.class));
    private Map<String, Map<String, ?>> collections;
    private final String collectionName;
    private final VolatileVectorStoreRecordCollectionOptions<Record> options;
    private final VectorStoreRecordDefinition recordDefinition;
    private final ObjectMapper objectMapper;

    public VolatileVectorStoreRecordCollection(String collectionName, VolatileVectorStoreRecordCollectionOptions<Record> options) {
        this.collectionName = collectionName;
        this.options = options;
        this.collections = new ConcurrentHashMap();
        this.recordDefinition = options.getRecordDefinition() != null ? options.getRecordDefinition() : VectorStoreRecordDefinition.fromRecordClass(this.options.getRecordClass());
        this.objectMapper = options.getObjectMapper() == null ? new ObjectMapper() : options.getObjectMapper();
        VectorStoreRecordDefinition.validateSupportedTypes(Collections.singletonList(this.recordDefinition.getKeyField()), supportedKeyTypes);
    }

    VolatileVectorStoreRecordCollection(String collectionName, Map<String, Map<String, ?>> collections, VolatileVectorStoreRecordCollectionOptions<Record> options) {
        this(collectionName, options);
        this.collections = collections;
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public Mono<Boolean> collectionExistsAsync() {
        return Mono.fromCallable(() -> this.collections.containsKey(this.collectionName));
    }

    @Override
    public Mono<VectorStoreRecordCollection<String, Record>> createCollectionAsync() {
        return Mono.fromRunnable(() -> this.collections.put(this.collectionName, new ConcurrentHashMap())).then(Mono.just((Object)this));
    }

    @Override
    public Mono<VectorStoreRecordCollection<String, Record>> createCollectionIfNotExistsAsync() {
        return Mono.fromRunnable(() -> this.collections.putIfAbsent(this.collectionName, new ConcurrentHashMap())).then(Mono.just((Object)this));
    }

    @Override
    public Mono<Void> deleteCollectionAsync() {
        return Mono.fromRunnable(() -> this.collections.remove(this.collectionName));
    }

    @Override
    public Mono<Record> getAsync(String key, GetRecordOptions options) {
        return Mono.fromCallable(() -> this.getCollection().get(key));
    }

    @Override
    public Mono<List<Record>> getBatchAsync(List<String> keys, GetRecordOptions options) {
        return Mono.fromCallable(() -> {
            Map<String, Record> collection = this.getCollection();
            return keys.stream().map(collection::get).collect(Collectors.toList());
        });
    }

    @Override
    public Mono<String> upsertAsync(Record data, UpsertRecordOptions options) {
        return Mono.fromCallable(() -> {
            try {
                ObjectNode objectNode = (ObjectNode)this.objectMapper.valueToTree(data);
                String key = objectNode.get(this.recordDefinition.getKeyField().getEffectiveStorageName()).asText();
                this.getCollection().put(key, data);
                return key;
            }
            catch (Exception e) {
                throw new SKException("Failure to serialize object. Ensure your model object can be serialized by Jackson, i.e the class is visible, has getters, constructor, annotations etc.", e);
            }
        });
    }

    @Override
    public Mono<List<String>> upsertBatchAsync(List<Record> data, UpsertRecordOptions options) {
        return Mono.fromCallable(() -> {
            Map<String, Record> collection = this.getCollection();
            return data.stream().map(record -> {
                try {
                    ObjectNode objectNode = (ObjectNode)this.objectMapper.valueToTree(record);
                    String key = objectNode.get(this.recordDefinition.getKeyField().getEffectiveStorageName()).asText();
                    collection.put(key, record);
                    return key;
                }
                catch (Exception e) {
                    throw new SKException("Failure to serialize object. Ensure your model object can be serialized by Jackson, i.e the class is visible, has getters, constructor, annotations etc.", e);
                }
            }).collect(Collectors.toList());
        });
    }

    @Override
    public Mono<Void> deleteAsync(String key, DeleteRecordOptions options) {
        return Mono.fromRunnable(() -> this.getCollection().remove(key));
    }

    @Override
    public Mono<Void> deleteBatchAsync(List<String> strings, DeleteRecordOptions options) {
        return Mono.fromRunnable(() -> {
            Map<String, Record> collection = this.getCollection();
            strings.forEach(collection::remove);
        });
    }

    private Map<String, Record> getCollection() {
        if (!this.collections.containsKey(this.collectionName)) {
            throw new IllegalStateException(String.format("Collection %s does not exist.", this.collectionName));
        }
        return this.collections.get(this.collectionName);
    }

    private List<Float> arrayNodeToFloatList(ArrayNode arrayNode) {
        return Stream.iterate(0, i -> i + 1).limit(arrayNode.size()).map(i -> Float.valueOf(arrayNode.get(i.intValue()).floatValue())).collect(Collectors.toList());
    }

    @Override
    public Mono<VectorSearchResults<Record>> searchAsync(List<Float> vector, VectorSearchOptions options) {
        if (this.recordDefinition.getVectorFields().isEmpty()) {
            throw new SKException("No vector fields defined. Cannot perform vector search");
        }
        return Mono.fromCallable(() -> {
            VectorStoreRecordVectorField firstVectorField = this.recordDefinition.getVectorFields().get(0);
            VectorSearchOptions effectiveOptions = options == null ? VectorSearchOptions.createDefault(firstVectorField.getName()) : options;
            VectorStoreRecordVectorField vectorField = effectiveOptions.getVectorFieldName() == null ? firstVectorField : (VectorStoreRecordVectorField)this.recordDefinition.getField(effectiveOptions.getVectorFieldName());
            DistanceFunction distanceFunction = vectorField.getDistanceFunction() == DistanceFunction.UNDEFINED ? DistanceFunction.EUCLIDEAN_DISTANCE : vectorField.getDistanceFunction();
            List<Record> records = VolatileVectorStoreCollectionSearchMapping.filterRecords(new ArrayList<Record>(this.getCollection().values()), effectiveOptions.getVectorSearchFilter(), this.recordDefinition, this.objectMapper);
            return new VectorSearchResults<Record>(VectorOperations.exactSimilaritySearch(records, vector, vectorField, distanceFunction, effectiveOptions));
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

