/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data;

import com.microsoft.semantickernel.data.VectorStoreTextSearchOptions;
import com.microsoft.semantickernel.data.textsearch.DefaultTextSearchResultMapper;
import com.microsoft.semantickernel.data.textsearch.DefaultTextSearchStringMapper;
import com.microsoft.semantickernel.data.textsearch.KernelSearchResults;
import com.microsoft.semantickernel.data.textsearch.TextSearch;
import com.microsoft.semantickernel.data.textsearch.TextSearchOptions;
import com.microsoft.semantickernel.data.textsearch.TextSearchResult;
import com.microsoft.semantickernel.data.textsearch.TextSearchResultMapper;
import com.microsoft.semantickernel.data.textsearch.TextSearchStringMapper;
import com.microsoft.semantickernel.data.vectorsearch.VectorSearchFilter;
import com.microsoft.semantickernel.data.vectorsearch.VectorSearchResults;
import com.microsoft.semantickernel.data.vectorsearch.VectorizedSearch;
import com.microsoft.semantickernel.data.vectorstorage.options.VectorSearchOptions;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.services.textembedding.TextEmbeddingGenerationService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class VectorStoreTextSearch<Record>
implements TextSearch {
    private final VectorizedSearch<Record> vectorizedSearch;
    private final TextEmbeddingGenerationService textEmbeddingGenerationService;
    private final TextSearchStringMapper stringMapper;
    private final TextSearchResultMapper resultMapper;
    private final VectorStoreTextSearchOptions options;

    public VectorStoreTextSearch(@Nonnull VectorizedSearch<Record> vectorizedSearch, @Nonnull TextEmbeddingGenerationService textEmbeddingGenerationService, @Nullable TextSearchStringMapper stringMapper, @Nullable TextSearchResultMapper resultMapper, @Nullable VectorStoreTextSearchOptions options) {
        this.vectorizedSearch = vectorizedSearch;
        this.textEmbeddingGenerationService = textEmbeddingGenerationService;
        this.stringMapper = stringMapper == null ? new DefaultTextSearchStringMapper() : stringMapper;
        this.resultMapper = resultMapper == null ? new DefaultTextSearchResultMapper() : resultMapper;
        this.options = options == null ? new VectorStoreTextSearchOptions() : options;
    }

    private Mono<VectorSearchResults<Record>> executeSearchAsync(String query, TextSearchOptions options) {
        if (options == null) {
            options = TextSearchOptions.createDefault();
        }
        VectorSearchOptions vectorSearchOptions = VectorSearchOptions.builder().withVectorSearchFilter(options.getFilter() != null ? new VectorSearchFilter(options.getFilter().getFilterClauses()) : null).withTop(options.getTop()).withSkip(options.getSkip()).withIncludeTotalCount(options.isIncludeTotalCount()).build();
        return this.textEmbeddingGenerationService.generateEmbeddingAsync(query).flatMap(embedding -> this.vectorizedSearch.searchAsync(embedding.getVector(), vectorSearchOptions));
    }

    @Override
    public Mono<KernelSearchResults<String>> searchAsync(String query, TextSearchOptions options) {
        return this.executeSearchAsync(query, options).map(results -> new KernelSearchResults(results.getResults().stream().map(r -> this.stringMapper.fromResultToString(r.getRecord())).collect(Collectors.toList()), results.getTotalCount(), results.getMetadata()));
    }

    @Override
    public Mono<KernelSearchResults<TextSearchResult>> getTextSearchResultsAsync(String query, TextSearchOptions options) {
        return this.executeSearchAsync(query, options).map(results -> new KernelSearchResults(results.getResults().stream().map(r -> this.resultMapper.fromResultToTextSearchResult(r.getRecord())).collect(Collectors.toList()), results.getTotalCount(), results.getMetadata()));
    }

    @Override
    public Mono<KernelSearchResults<Object>> getSearchResultsAsync(String query, TextSearchOptions options) {
        return this.executeSearchAsync(query, options).map(results -> new KernelSearchResults(results.getResults().stream().map(r -> this.resultMapper.fromResultToTextSearchResult(r.getRecord())).collect(Collectors.toList()), results.getTotalCount(), results.getMetadata()));
    }

    public static <Record> Builder<Record> builder() {
        return new Builder();
    }

    public static class Builder<Record> {
        @Nullable
        private VectorizedSearch<Record> vectorizedSearch;
        @Nullable
        private TextEmbeddingGenerationService textEmbeddingGenerationService;
        @Nullable
        private TextSearchStringMapper stringMapper;
        @Nullable
        private TextSearchResultMapper resultMapper;
        @Nullable
        private VectorStoreTextSearchOptions options;

        public Builder<Record> withVectorizedSearch(VectorizedSearch<Record> vectorizedSearch) {
            this.vectorizedSearch = vectorizedSearch;
            return this;
        }

        public Builder<Record> withTextEmbeddingGenerationService(TextEmbeddingGenerationService textEmbeddingGenerationService) {
            this.textEmbeddingGenerationService = textEmbeddingGenerationService;
            return this;
        }

        public Builder<Record> withStringMapper(TextSearchStringMapper stringMapper) {
            this.stringMapper = stringMapper;
            return this;
        }

        public Builder<Record> withResultMapper(TextSearchResultMapper resultMapper) {
            this.resultMapper = resultMapper;
            return this;
        }

        public Builder<Record> withOptions(VectorStoreTextSearchOptions options) {
            this.options = options;
            return this;
        }

        public VectorStoreTextSearch<Record> build() {
            if (this.vectorizedSearch == null) {
                throw new SKException("Vectorized search is required");
            }
            if (this.textEmbeddingGenerationService == null) {
                throw new SKException("Text embedding generation service is required");
            }
            return new VectorStoreTextSearch<Record>(this.vectorizedSearch, this.textEmbeddingGenerationService, this.stringMapper, this.resultMapper, this.options);
        }
    }
}

