/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.contextvariables.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.exceptions.SKException;

public final class ContextVariableJacksonConverter {
    public static <T> ContextVariableTypeConverter<T> create(Class<T> type, ObjectMapper mapper) {
        return ContextVariableJacksonConverter.builder(type, mapper).build();
    }

    public static <T> ContextVariableTypeConverter<T> create(Class<T> type) {
        return ContextVariableJacksonConverter.create(type, new ObjectMapper());
    }

    public static <T> ContextVariableTypeConverter.Builder<T> builder(Class<T> type) {
        return ContextVariableJacksonConverter.builder(type, new ObjectMapper());
    }

    public static <T> ContextVariableTypeConverter.Builder<T> builder(Class<T> type, ObjectMapper mapper) {
        return ContextVariableTypeConverter.builder(type).fromPromptString(str -> {
            try {
                return mapper.readValue(str, type);
            }
            catch (JsonProcessingException e) {
                throw new SKException("Failed to deserialize object", e);
            }
        }).toPromptString(obj -> {
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new SKException("Failed to serialize object", e);
            }
        });
    }
}

