/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.audio;

import javax.annotation.Nullable;

public class AudioToTextExecutionSettings {
    @Nullable
    private final String deploymentName;
    @Nullable
    private final String filename;
    private final String responseFormat;
    @Nullable
    private final String language;
    @Nullable
    private final String prompt;
    @Nullable
    private final Double temperature;

    public AudioToTextExecutionSettings(@Nullable String deploymentName, @Nullable String filename, String responseFormat, @Nullable String language, @Nullable String prompt, @Nullable Double temperature) {
        this.deploymentName = deploymentName;
        this.filename = filename;
        this.responseFormat = responseFormat;
        this.language = language;
        this.prompt = prompt;
        this.temperature = temperature;
    }

    @Nullable
    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Nullable
    public String getFilename() {
        return this.filename;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public String getPrompt() {
        return this.prompt;
    }

    @Nullable
    public Double getTemperature() {
        return this.temperature;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String deploymentName = null;
        @Nullable
        private String filename = null;
        @Nullable
        private String responseFormat = null;
        @Nullable
        private String language = null;
        @Nullable
        private String prompt = null;
        @Nullable
        private Double temperature = null;

        public Builder withDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder withResponseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder withLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder withPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder withTemperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AudioToTextExecutionSettings build() {
            if (this.responseFormat == null) {
                this.responseFormat = "json";
            }
            return new AudioToTextExecutionSettings(this.deploymentName, this.filename, this.responseFormat, this.language, this.prompt, this.temperature);
        }
    }
}

