/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.textcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.aiservices.openai.implementation.OpenAIRequestSettings;
import com.microsoft.semantickernel.aiservices.openai.textcompletion.OpenAIStreamingTextContent;
import com.microsoft.semantickernel.exceptions.AIException;
import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.services.StreamingTextContent;
import com.microsoft.semantickernel.services.textcompletion.TextContent;
import com.microsoft.semantickernel.services.textcompletion.TextGenerationService;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAITextGenerationService
extends OpenAiService<OpenAIAsyncClient>
implements TextGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAITextGenerationService.class);

    protected OpenAITextGenerationService(OpenAIAsyncClient client, String modelId, @Nullable String serviceId, String deploymentName) {
        super(client, serviceId, modelId, deploymentName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Mono<List<TextContent>> getTextContentsAsync(String prompt, @Nullable PromptExecutionSettings executionSettings, @Nullable Kernel kernel) {
        return this.internalCompleteTextAsync(prompt, executionSettings);
    }

    public Flux<StreamingTextContent> getStreamingTextContentsAsync(String prompt, @Nullable PromptExecutionSettings executionSettings, @Nullable Kernel kernel) {
        return this.internalCompleteTextAsync(prompt, executionSettings).flatMapMany(it -> Flux.fromStream(it.stream()).map(OpenAIStreamingTextContent::new));
    }

    protected Mono<List<TextContent>> internalCompleteTextAsync(String text, @Nullable PromptExecutionSettings requestSettings) {
        CompletionsOptions completionsOptions = this.getCompletionsOptions(text, requestSettings);
        return ((OpenAIAsyncClient)this.getClient()).getCompletionsWithResponse(this.getDeploymentName(), completionsOptions, OpenAIRequestSettings.getRequestOptions()).flatMap(completionsResult -> {
            if (completionsResult.getStatusCode() >= 400) {
                return Mono.error((Throwable)new AIException(AIException.ErrorCodes.SERVICE_ERROR, "Request failed: " + completionsResult.getStatusCode()));
            }
            return Mono.just((Object)((Completions)completionsResult.getValue()));
        }).map(completions -> {
            FunctionResultMetadata metadata = FunctionResultMetadata.build((String)completions.getId(), (Object)completions.getUsage(), (OffsetDateTime)completions.getCreatedAt());
            return completions.getChoices().stream().map(choice -> new TextContent(choice.getText(), completionsOptions.getModel(), metadata)).collect(Collectors.toList());
        });
    }

    private CompletionsOptions getCompletionsOptions(String text, @Nullable PromptExecutionSettings requestSettings) {
        text = StringEscapeUtils.unescapeXml((String)text);
        if (requestSettings == null) {
            return new CompletionsOptions(Collections.singletonList(text)).setMaxTokens(Integer.valueOf(256));
        }
        if (requestSettings.getMaxTokens() < 1) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "Max tokens must be >0");
        }
        if (requestSettings.getResultsPerPrompt() < 1 || requestSettings.getResultsPerPrompt() > 128) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, String.format("Results per prompt must be in range between 1 and %d, inclusive.", 128));
        }
        CompletionsOptions options = new CompletionsOptions(Collections.singletonList(text)).setMaxTokens(Integer.valueOf(requestSettings.getMaxTokens())).setTemperature(Double.valueOf(requestSettings.getTemperature())).setTopP(Double.valueOf(requestSettings.getTopP())).setFrequencyPenalty(Double.valueOf(requestSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(requestSettings.getPresencePenalty())).setModel(this.getModelId()).setN(Integer.valueOf(requestSettings.getResultsPerPrompt())).setUser(requestSettings.getUser()).setBestOf(Integer.valueOf(requestSettings.getBestOf())).setLogitBias(new HashMap());
        return options;
    }

    public static class Builder
    extends TextGenerationService.Builder {
        public TextGenerationService build() {
            if (this.client == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI client must be provided");
            }
            if (this.modelId == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI model id must be provided");
            }
            if (this.deploymentName == null) {
                LOGGER.debug("Deployment name is not provided, using model id as deployment name");
                this.deploymentName = this.modelId;
            }
            return new OpenAITextGenerationService((OpenAIAsyncClient)this.client, this.modelId, this.serviceId, this.deploymentName);
        }
    }
}

