/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GroupCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.GroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.PrintJobCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintJobRequestBuilder;
import com.microsoft.graph.requests.PrinterShareRequest;
import com.microsoft.graph.requests.PrinterWithReferenceRequestBuilder;
import com.microsoft.graph.requests.UserCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrinterShareRequestBuilder
extends BaseRequestBuilder<PrinterShare> {
    public PrinterShareRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public PrinterShareRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public PrinterShareRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new PrinterShareRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public PrintJobCollectionRequestBuilder jobs() {
        return new PrintJobCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("jobs"), this.getClient(), null);
    }

    @Nonnull
    public PrintJobRequestBuilder jobs(@Nonnull String id) {
        return new PrintJobRequestBuilder(this.getRequestUrlWithAdditionalSegment("jobs") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public GroupCollectionWithReferencesRequestBuilder allowedGroups() {
        return new GroupCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("allowedGroups"), this.getClient(), null);
    }

    @Nonnull
    public GroupWithReferenceRequestBuilder allowedGroups(@Nonnull String id) {
        return new GroupWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("allowedGroups") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public UserCollectionWithReferencesRequestBuilder allowedUsers() {
        return new UserCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("allowedUsers"), this.getClient(), null);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder allowedUsers(@Nonnull String id) {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("allowedUsers") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public PrinterWithReferenceRequestBuilder printer() {
        return new PrinterWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("printer"), this.getClient(), null);
    }
}

