/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.schema.EntitySerialization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Entity
implements EntitySerialization {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private HashMap<String, JsonNode> properties = new HashMap();
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String type;

    public static Entity clone(final Entity entity) {
        if (entity == null) {
            return null;
        }
        return new Entity(){
            {
                this.setType(entity.getType());
                for (String key : entity.getProperties().keySet()) {
                    this.setProperties(key, entity.getProperties().get(key));
                }
            }
        };
    }

    public static List<Entity> cloneList(List<? extends Entity> entities) {
        if (entities == null) {
            return null;
        }
        return entities.stream().map(entity -> Entity.clone(entity)).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String withType) {
        this.type = withType;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void setProperties(String key, JsonNode value) {
        this.properties.put(key, value);
    }

    @JsonIgnore
    public <T extends EntitySerialization> T getAs(Class<T> classType) {
        return Entity.getAs(this, classType);
    }

    public static <T extends EntitySerialization> T getAs(EntitySerialization entity, Class<T> classType) {
        String tempJson;
        try {
            tempJson = objectMapper.writeValueAsString((Object)entity);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
        EntitySerialization newObj = null;
        try {
            newObj = (EntitySerialization)objectMapper.readValue(tempJson, classType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return (T)newObj;
    }

    @JsonIgnore
    public <T extends EntitySerialization> Entity setAs(T obj) throws IllegalArgumentException {
        Entity tempEntity;
        String tempJson;
        try {
            tempJson = objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            tempEntity = (Entity)objectMapper.readValue(tempJson, Entity.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        for (Map.Entry<String, JsonNode> entry : tempEntity.properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
        this.type = tempEntity.getType();
        return this;
    }

    static {
        objectMapper.findAndRegisterModules();
    }
}

