/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.Authenticator;
import com.microsoft.bot.connector.authentication.OAuthConfiguration;
import com.microsoft.bot.connector.authentication.Retry;
import com.microsoft.bot.connector.authentication.RetryAfterHelper;
import com.microsoft.bot.connector.authentication.RetryException;
import com.microsoft.bot.connector.authentication.RetryParams;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CredentialsAuthenticator
implements Authenticator {
    private final ConfidentialClientApplication app;
    private final ClientCredentialParameters parameters;

    CredentialsAuthenticator(String appId, String appPassword, OAuthConfiguration configuration) throws MalformedURLException {
        this.app = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)appId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)appPassword)).authority(configuration.getAuthority())).build();
        this.parameters = ClientCredentialParameters.builder(Collections.singleton(configuration.getScope())).build();
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken() {
        return Retry.run(() -> this.app.acquireToken(this.parameters).exceptionally(exception -> {
            throw new AuthenticationException((Throwable)exception);
        }), (exception, count) -> {
            if (exception instanceof RetryException && exception.getCause() instanceof MsalServiceException) {
                MsalServiceException serviceException = (MsalServiceException)exception.getCause();
                if (serviceException.headers().containsKey("Retry-After")) {
                    return RetryAfterHelper.processRetry((List)serviceException.headers().get("Retry-After"), count);
                }
                count = count + 1;
                return RetryParams.defaultBackOff(count);
            }
            return RetryParams.stopRetrying();
        });
    }
}

