/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.HashMap;
import java.util.Map;

public class ClaimsIdentity {
    private String issuer;
    private String type;
    private Map<String, String> claims;

    private ClaimsIdentity() {
        this("", new HashMap<String, String>());
    }

    public ClaimsIdentity(String withAuthIssuer) {
        this(withAuthIssuer, new HashMap<String, String>());
    }

    public ClaimsIdentity(String withAuthIssuer, Map<String, String> withClaims) {
        this(withAuthIssuer, null, withClaims);
    }

    public ClaimsIdentity(String withAuthIssuer, String withType, Map<String, String> withClaims) {
        this.issuer = withAuthIssuer;
        this.type = withType;
        this.claims = withClaims;
    }

    public ClaimsIdentity(DecodedJWT jwt) {
        this.claims = new HashMap<String, String>();
        if (jwt.getClaims() != null) {
            jwt.getClaims().forEach((k, v) -> this.claims.put((String)k, v.asString()));
        }
        this.issuer = jwt.getIssuer();
        this.type = jwt.getType();
    }

    public boolean isAuthenticated() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public Map<String, String> claims() {
        return this.claims;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getType() {
        return this.type;
    }
}

