/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.AuthenticationConstants;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenExtractor;
import com.microsoft.bot.connector.authentication.TokenValidationParameters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public final class ChannelValidation {
    private static String openIdMetaDataUrl = "https://login.botframework.com/v1/.well-known/openidconfiguration";

    private ChannelValidation() {
    }

    public static TokenValidationParameters getTokenValidationParameters() {
        TokenValidationParameters tokenValidationParameters = new TokenValidationParameters();
        tokenValidationParameters.validateIssuer = true;
        ArrayList<String> validIssuers = new ArrayList<String>();
        validIssuers.add("https://api.botframework.com");
        tokenValidationParameters.validIssuers = validIssuers;
        tokenValidationParameters.validateAudience = false;
        tokenValidationParameters.validateLifetime = true;
        tokenValidationParameters.clockSkew = Duration.ofMinutes(5L);
        tokenValidationParameters.requireSignedTokens = true;
        return tokenValidationParameters;
    }

    public static String getOpenIdMetaDataUrl() {
        return openIdMetaDataUrl;
    }

    public static void setOpenIdMetaDataUrl(String withOpenIdMetaDataUrl) {
        openIdMetaDataUrl = withOpenIdMetaDataUrl;
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, String channelId) {
        return ChannelValidation.authenticateToken(authHeader, credentials, channelId, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, String channelId, AuthenticationConfiguration authConfig) {
        JwtTokenExtractor tokenExtractor = new JwtTokenExtractor(ChannelValidation.getTokenValidationParameters(), ChannelValidation.getOpenIdMetaDataUrl(), AuthenticationConstants.ALLOWED_SIGNING_ALGORITHMS);
        return tokenExtractor.getIdentity(authHeader, channelId).thenCompose(identity -> {
            if (identity == null) {
                throw new AuthenticationException("Invalid Identity");
            }
            if (!identity.isAuthenticated()) {
                throw new AuthenticationException("Token Not Authenticated");
            }
            if (!identity.getIssuer().equalsIgnoreCase("https://api.botframework.com")) {
                throw new AuthenticationException("Wrong Issuer");
            }
            String appIdFromAudienceClaim = identity.claims().get("aud");
            if (StringUtils.isEmpty((CharSequence)appIdFromAudienceClaim)) {
                throw new AuthenticationException("No Audience Claim");
            }
            return credentials.isValidAppId(appIdFromAudienceClaim).thenApply(isValid -> {
                if (!isValid.booleanValue()) {
                    throw new AuthenticationException(String.format("Invalid AppId passed on token: '%s'.", appIdFromAudienceClaim));
                }
                return identity;
            });
        });
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, String channelId, String serviceUrl) {
        return ChannelValidation.authenticateToken(authHeader, credentials, channelId, serviceUrl, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, String channelId, String serviceUrl, AuthenticationConfiguration authConfig) {
        return ChannelValidation.authenticateToken(authHeader, credentials, channelId, authConfig).thenApply(identity -> {
            if (!identity.claims().containsKey("serviceurl")) {
                throw new AuthenticationException(String.format("'%s' claim is required on Channel Token.", "serviceurl"));
            }
            if (!serviceUrl.equalsIgnoreCase(identity.claims().get("serviceurl"))) {
                throw new AuthenticationException(String.format("'%s' claim does not match service url provided (%s).", "serviceurl", serviceUrl));
            }
            return identity;
        });
    }
}

