/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.Authenticator;
import com.microsoft.bot.connector.authentication.CertificateAppCredentialsOptions;
import com.microsoft.bot.connector.authentication.OAuthConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;

public class CertificateAuthenticator
implements Authenticator {
    private final ConfidentialClientApplication app;
    private final ClientCredentialParameters parameters;

    public CertificateAuthenticator(CertificateAppCredentialsOptions withOptions, OAuthConfiguration withConfiguration) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, IOException {
        this.app = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)withOptions.getAppId(), (IClientCredential)ClientCredentialFactory.createFromCertificate((InputStream)withOptions.getPkcs12Certificate(), (String)withOptions.getPkcs12Password())).authority(withConfiguration.getAuthority())).sendX5c(withOptions.getSendX5c()).build();
        this.parameters = ClientCredentialParameters.builder(Collections.singleton(withConfiguration.getScope())).build();
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken() {
        return this.app.acquireToken(this.parameters).exceptionally(exception -> {
            throw new AuthenticationException((Throwable)exception);
        });
    }
}

