/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.connector.authentication.OpenIdMetadata;
import com.microsoft.bot.connector.authentication.OpenIdMetadataKey;
import java.io.IOException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingOpenIdMetadata
implements OpenIdMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingOpenIdMetadata.class);
    private static final int CACHE_DAYS = 1;
    private static final int CACHE_HOURS = 1;
    private String url;
    private long lastUpdated;
    private ObjectMapper mapper;
    private Map<String, Jwk> keyCache = new HashMap<String, Jwk>();
    private final Object sync = new Object();

    CachingOpenIdMetadata(String withUrl) {
        this.url = withUrl;
        this.mapper = new ObjectMapper().findAndRegisterModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenIdMetadataKey getKey(String keyId) {
        Object object = this.sync;
        synchronized (object) {
            OpenIdMetadataKey key;
            if (this.lastUpdated < System.currentTimeMillis() - Duration.ofDays(1L).toMillis()) {
                this.refreshCache();
            }
            if ((key = this.findKey(keyId)) == null && this.lastUpdated < System.currentTimeMillis() - Duration.ofHours(1L).toMillis()) {
                this.refreshCache();
                key = this.findKey(keyId);
            }
            return key;
        }
    }

    private void refreshCache() {
        this.keyCache.clear();
        try {
            URL openIdUrl = new URL(this.url);
            HashMap openIdConf = (HashMap)this.mapper.readValue(openIdUrl, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            URL keysUrl = new URL(openIdConf.get("jwks_uri").toString());
            this.lastUpdated = System.currentTimeMillis();
            UrlJwkProvider provider = new UrlJwkProvider(keysUrl);
            this.keyCache = provider.getAll().stream().collect(Collectors.toMap(Jwk::getId, jwk -> jwk));
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to load openID config: %s", e.getMessage()));
            this.lastUpdated = 0L;
        }
        catch (SigningKeyNotFoundException keyexception) {
            LOGGER.error("refreshCache", (Throwable)keyexception);
            this.lastUpdated = 0L;
        }
    }

    private OpenIdMetadataKey findKey(String keyId) {
        if (!this.keyCache.containsKey(keyId)) {
            LOGGER.warn("findKey: keyId " + keyId + " doesn't exist.");
            return null;
        }
        try {
            Jwk jwk = this.keyCache.get(keyId);
            OpenIdMetadataKey key = new OpenIdMetadataKey();
            key.key = (RSAPublicKey)jwk.getPublicKey();
            key.endorsements = (List)jwk.getAdditionalAttributes().get("endorsements");
            key.certificateChain = jwk.getCertificateChain();
            return key;
        }
        catch (JwkException e) {
            String errorDescription = String.format("Failed to load keys: %s", e.getMessage());
            LOGGER.warn(errorDescription);
            return null;
        }
    }
}

