/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.bot.connector.authentication.AppCredentialsInterceptor;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.Authenticator;
import com.microsoft.bot.restclient.credentials.ServiceClientCredentials;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;

public abstract class AppCredentials
implements ServiceClientCredentials {
    private String appId;
    private String authTenant;
    private String authScope;
    private Authenticator authenticator;

    public AppCredentials(String withChannelAuthTenant) {
        this(withChannelAuthTenant, "https://api.botframework.com/.default");
    }

    public AppCredentials(String withChannelAuthTenant, String withOAuthScope) {
        this.setChannelAuthTenant(withChannelAuthTenant);
        this.authScope = StringUtils.isEmpty((CharSequence)withOAuthScope) ? "https://api.botframework.com/.default" : withOAuthScope;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String withAppId) {
        this.appId = withAppId;
    }

    public String getChannelAuthTenant() {
        return StringUtils.isEmpty((CharSequence)this.authTenant) ? "botframework.com" : this.getAuthTenant();
    }

    public void setChannelAuthTenant(String withAuthTenant) {
        try {
            String endPointUrl = String.format("https://login.microsoftonline.com/%s", withAuthTenant);
            new URL(endPointUrl).toString();
            this.setAuthTenant(withAuthTenant);
        }
        catch (MalformedURLException e) {
            throw new AuthenticationException("Invalid channel auth tenant: " + withAuthTenant);
        }
    }

    public String oAuthEndpoint() {
        return String.format("https://login.microsoftonline.com/%s", this.getChannelAuthTenant());
    }

    public String oAuthScope() {
        return this.authScope;
    }

    protected String getAuthTenant() {
        return this.authTenant;
    }

    protected void setAuthTenant(String withAuthTenant) {
        this.authTenant = withAuthTenant;
    }

    public CompletableFuture<String> getToken() {
        CompletableFuture<String> result;
        try {
            result = this.getAuthenticator().acquireToken().thenApply(IAuthenticationResult::accessToken);
        }
        catch (MalformedURLException e) {
            result = new CompletableFuture<String>();
            result.completeExceptionally(new AuthenticationException(e));
        }
        return result;
    }

    boolean shouldSetToken(String url) {
        return !StringUtils.isBlank((CharSequence)this.getAppId()) && !this.getAppId().equals("AnonymousSkill");
    }

    private Authenticator getAuthenticator() throws MalformedURLException {
        if (this.authenticator == null) {
            this.authenticator = this.buildAuthenticator();
        }
        return this.authenticator;
    }

    protected abstract Authenticator buildAuthenticator() throws MalformedURLException;

    @Override
    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new AppCredentialsInterceptor(this));
    }
}

