/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.instrumentation;

import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.tracing.ProcessKind;
import java.util.Map;

public class Tracer {
    private static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    private static com.azure.core.util.tracing.Tracer tracer;
    private static volatile boolean initialized;

    private Tracer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initializeTracer(com.azure.core.util.tracing.Tracer tracer) {
        if (initialized) return;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (initialized) return;
            Tracer.tracer = IS_TRACING_DISABLED ? null : tracer;
            initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Span startSpan(String spanName) {
        return Tracer.startSpan(spanName, Context.NONE, ProcessKind.PROCESS, null);
    }

    public static Span startSpan(String spanName, Map<String, String> attributes) {
        return Tracer.startSpan(spanName, Context.NONE, ProcessKind.PROCESS, attributes);
    }

    public static Span startSpan(String spanName, Context context, ProcessKind kind, Map<String, String> attributes) {
        Context span = tracer == null ? null : tracer.start(spanName, context, kind);
        return new Span(span, attributes);
    }

    static {
        initialized = false;
    }

    public static class Span
    implements AutoCloseable {
        private final Context span;
        private Throwable throwable;

        private Span(Context span, Map<String, String> attributes) {
            this.span = span;
            this.setAttributes(attributes);
        }

        @Override
        public void close() {
            if (tracer != null && this.span != null) {
                String errorCondition = "success";
                if (this.throwable != null) {
                    errorCondition = this.throwable.getLocalizedMessage();
                }
                tracer.end(errorCondition, this.throwable, this.span);
            }
        }

        public void addException(Exception e) {
            this.throwable = e;
        }

        public void setAttributes(Map<String, String> attributes) {
            if (tracer != null && attributes != null && this.span != null) {
                attributes.forEach((k, v) -> tracer.setAttribute(k, v, this.span));
            }
        }
    }
}

