/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.instrumentation;

import com.microsoft.azure.kusto.data.instrumentation.FunctionOneException;
import com.microsoft.azure.kusto.data.instrumentation.FunctionTwoExceptions;
import com.microsoft.azure.kusto.data.instrumentation.SupplierOneException;
import com.microsoft.azure.kusto.data.instrumentation.SupplierTwoExceptions;
import com.microsoft.azure.kusto.data.instrumentation.Tracer;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class MonitoredActivity {
    public static void invoke(Runnable runnable, String nameOfSpan) {
        MonitoredActivity.invoke(runnable, nameOfSpan, new HashMap<String, String>());
    }

    public static void invoke(Runnable runnable, String nameOfSpan, Map<String, String> attributes) {
        try (Tracer.Span ignored = Tracer.startSpan(nameOfSpan, attributes);){
            runnable.run();
        }
    }

    public static <T, U extends Exception> T invoke(SupplierOneException<T, U> supplier, String nameOfSpan) throws U {
        return (T)MonitoredActivity.invoke(supplier::get, nameOfSpan, new HashMap<String, String>());
    }

    public static <T> Mono<T> wrap(Mono<T> mono, String nameOfSpan) {
        return MonitoredActivity.wrap(mono, nameOfSpan, new HashMap<String, String>());
    }

    public static <T> Mono<T> wrap(Mono<T> mono, String nameOfSpan, Map<String, String> attributes) {
        return Mono.defer(() -> {
            Tracer.Span span = Tracer.startSpan(nameOfSpan, attributes);
            return mono.doFinally(ignore -> span.close());
        });
    }

    public static <T, U extends Exception> Mono<T> invokeAsync(FunctionOneException<Mono<T>, Tracer.Span, U> function, String nameOfSpan, Map<String, String> attributes) {
        return Mono.defer(() -> {
            Tracer.Span span = Tracer.startSpan(nameOfSpan, attributes);
            try {
                return ((Mono)function.apply(span)).doOnSuccess(ignored -> span.close()).doOnError(e -> span.addException((Exception)e));
            }
            catch (Exception e2) {
                span.addException(e2);
                return Mono.error((Throwable)e2);
            }
        });
    }

    public static <T, U extends Exception> T invoke(SupplierOneException<T, U> supplier, String nameOfSpan, Map<String, String> attributes) throws U {
        return (T)MonitoredActivity.invoke(supplier::get, nameOfSpan, attributes);
    }

    public static <T, U1 extends Exception, U2 extends Exception> T invoke(SupplierTwoExceptions<T, U1, U2> supplier, String nameOfSpan) throws U1, U2 {
        return MonitoredActivity.invoke(supplier, nameOfSpan, new HashMap<String, String>());
    }

    public static <T, U1 extends Exception, U2 extends Exception> T invoke(SupplierTwoExceptions<T, U1, U2> supplier, String nameOfSpan, Map<String, String> attributes) throws U1, U2 {
        Throwable throwable = null;
        try (Tracer.Span span = Tracer.startSpan(nameOfSpan, attributes);){
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            try {
                span.addException(e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static <T, U extends Exception> T invoke(FunctionOneException<T, Tracer.Span, U> function, String nameOfSpan, Map<String, String> attributes) throws U {
        return (T)MonitoredActivity.invoke(function::apply, nameOfSpan, attributes);
    }

    public static <T, U1 extends Exception, U2 extends Exception> T invoke(FunctionTwoExceptions<T, Tracer.Span, U1, U2> function, String nameOfSpan, Map<String, String> attributes) throws U1, U2 {
        Throwable throwable = null;
        try (Tracer.Span span = Tracer.startSpan(nameOfSpan, attributes);){
            T t = function.apply(span);
            return t;
        }
        catch (Exception e) {
            try {
                span.addException(e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

