/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.servicelinker;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.servicelinker.ServiceLinkerManager;
import com.azure.resourcemanager.servicelinker.models.LinkerResource;
import com.azure.resourcemanager.servicelinker.models.Linkers;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinker;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerConsumer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ServiceLinkerModule
extends AbstractAzResourceModule<ServiceLinker, ServiceLinkerConsumer, LinkerResource> {
    public static final String NAME = "linkers";
    private final String targetResourceId;

    public ServiceLinkerModule(String targetResourceId, ServiceLinkerConsumer parent) {
        super(NAME, (AzResource)parent);
        this.targetResourceId = targetResourceId;
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, LinkerResource>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.list(this.targetResourceId).iterableByPage(ServiceLinkerModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    protected LinkerResource loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        assert (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resourceGroup})) : "resource group can not be empty";
        return Optional.ofNullable(this.getClient()).map(linkers -> linkers.get(this.targetResourceId, name)).orElse(null);
    }

    @Nonnull
    protected ServiceLinker newResource(@Nonnull LinkerResource remote) {
        return new ServiceLinker(remote, this);
    }

    @Nonnull
    protected ServiceLinker newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ServiceLinker(name, Objects.requireNonNull(resourceGroupName), this);
    }

    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        Optional.ofNullable(this.getClient()).ifPresent(linkers -> {
            ResourceId resource = ResourceId.fromString((String)resourceId);
            linkers.deleteByResourceGroup(this.targetResourceId, resource.name());
        });
    }

    @Nullable
    protected Linkers getClient() {
        return Optional.ofNullable(((ServiceLinkerConsumer)this.parent).getLinkerManager()).map(ServiceLinkerManager::linkers).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Service Connector";
    }
}

