/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.monitor;

import com.azure.monitor.query.LogsQueryClient;
import com.azure.monitor.query.LogsQueryClientBuilder;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.monitor.AzureLogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceModule;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class LogAnalyticsServiceWorkspaceSubscription
extends AbstractAzServiceSubscription<LogAnalyticsServiceWorkspaceSubscription, LogAnalyticsManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final LogAnalyticsWorkspaceModule logAnalyticsWorkspaceModule;
    @Nullable
    private final LogsQueryClient logsQueryClient;

    protected LogAnalyticsServiceWorkspaceSubscription(@Nonnull String subscriptionId, @Nonnull AzureLogAnalyticsWorkspace service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.logAnalyticsWorkspaceModule = new LogAnalyticsWorkspaceModule(this);
        this.logsQueryClient = new LogsQueryClientBuilder().credential(((AzureAccount)Azure.az(AzureAccount.class)).account().getTokenCredential(subscriptionId)).buildClient();
    }

    public LogAnalyticsWorkspaceModule logAnalyticsWorkspaces() {
        return this.logAnalyticsWorkspaceModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.logAnalyticsWorkspaceModule);
    }

    public LogsQueryClient getLosQueryClient() {
        return this.logsQueryClient;
    }

    @Nonnull
    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    @Generated
    public LogAnalyticsWorkspaceModule getLogAnalyticsWorkspaceModule() {
        return this.logAnalyticsWorkspaceModule;
    }

    @Nullable
    @Generated
    public LogsQueryClient getLogsQueryClient() {
        return this.logsQueryClient;
    }
}

