/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.identities;

import com.azure.resourcemanager.msi.MsiManager;
import com.azure.resourcemanager.msi.fluent.ManagedServiceIdentityClient;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentity;
import com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentityModule;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;

public class AzureManagedIdentitySubscription
extends AbstractAzServiceSubscription<AzureManagedIdentitySubscription, MsiManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final AzureManagedIdentityModule identityModule;

    protected AzureManagedIdentitySubscription(@Nonnull String subscriptionId, @Nonnull AzureManagedIdentity service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.identityModule = new AzureManagedIdentityModule(this);
    }

    protected AzureManagedIdentitySubscription(@Nonnull MsiManager manager, @Nonnull AzureManagedIdentity service) {
        this(((ManagedServiceIdentityClient)manager.serviceClient()).getSubscriptionId(), service);
    }

    public AzureManagedIdentityModule identity() {
        return this.identityModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.identityModule);
    }

    public List<Region> listSupportedRegions(@Nonnull String resourceType) {
        return super.listSupportedRegions(this.identityModule.getName());
    }

    @Nonnull
    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    @Generated
    public AzureManagedIdentityModule getIdentityModule() {
        return this.identityModule;
    }
}

