/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jetbrains.annotations.Contract;

public class ResourceGroupConfig {
    private String subscriptionId;
    private String name;
    private Region region;

    @Contract(value="null->null")
    public static ResourceGroupConfig fromResource(@Nullable ResourceGroup group) {
        if (Objects.isNull(group)) {
            return null;
        }
        return ResourceGroupConfig.builder().subscriptionId(group.getSubscriptionId()).name(group.getName()).region(group.getRegion()).build();
    }

    @Nonnull
    public ResourceGroup toResource() {
        ResourceGroup rg = (ResourceGroup)Azure.az(AzureResources.class).groups(this.subscriptionId).getOrDraft(this.name, this.name);
        if (rg.isDraftForCreating()) {
            ResourceGroupDraft draft = (ResourceGroupDraft)rg;
            draft.setRegion(this.region);
        }
        return rg;
    }

    @Generated
    public static ResourceGroupConfigBuilder builder() {
        return new ResourceGroupConfigBuilder();
    }

    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Region getRegion() {
        return this.region;
    }

    @Generated
    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRegion(Region region) {
        this.region = region;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceGroupConfig)) {
            return false;
        }
        ResourceGroupConfig other = (ResourceGroupConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Region this$region = this.getRegion();
        Region other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !((Object)this$region).equals(other$region));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceGroupConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Region $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceGroupConfig(subscriptionId=" + this.getSubscriptionId() + ", name=" + this.getName() + ", region=" + this.getRegion() + ")";
    }

    @Generated
    public ResourceGroupConfig() {
    }

    @Generated
    public ResourceGroupConfig(String subscriptionId, String name, Region region) {
        this.subscriptionId = subscriptionId;
        this.name = name;
        this.region = region;
    }

    @Generated
    public static class ResourceGroupConfigBuilder {
        @Generated
        private String subscriptionId;
        @Generated
        private String name;
        @Generated
        private Region region;

        @Generated
        ResourceGroupConfigBuilder() {
        }

        @Generated
        public ResourceGroupConfigBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Generated
        public ResourceGroupConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ResourceGroupConfigBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Generated
        public ResourceGroupConfig build() {
            return new ResourceGroupConfig(this.subscriptionId, this.name, this.region);
        }

        @Generated
        public String toString() {
            return "ResourceGroupConfig.ResourceGroupConfigBuilder(subscriptionId=" + this.subscriptionId + ", name=" + this.name + ", region=" + this.region + ")";
        }
    }
}

