/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.azure.resourcemanager.resources.fluentcore.utils.ResourceNamer;
import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.exception.CommandExecuteException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class Utils {
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static final String POM = "pom";
    private static final String JAR = "jar";
    private static final String WAR = "war";
    private static final String EAR = "ear";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyMMddHHmmss");
    private static final String MAIN_CLASS = "Main-Class";
    private static final String CLASS = ".class";
    private static final String SPRING_BOOT_CLASSES = "Spring-Boot-Classes";
    private static final String START_CLASS = "Start-Class";
    private static final String DEFAULT_SPRING_BOOT_CLASSES = "BOOT-INF/classes/";
    public static final int DEFAULT_TIMEOUT = 10000;

    public static String generateRandomResourceName(@Nonnull String prefix, int maxLength) {
        String name = String.format("%s-%s", prefix, Utils.getTimestamp());
        return name.length() <= maxLength ? name : new ResourceNamer("").getRandomName(name.substring(0, maxLength - 10), maxLength);
    }

    public static String getTimestamp() {
        return DATE_FORMAT.format(new Date());
    }

    public static int getJavaMajorVersion(String javaVersion) {
        String runtimeJavaMajorVersion = StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.") ? StringUtils.substring((String)javaVersion, (int)2, (int)3) : StringUtils.split((String)javaVersion, (String)".")[0];
        return Integer.parseInt(runtimeJavaMajorVersion);
    }

    public static int getArtifactCompileVersion(@Nonnull File artifact) throws AzureToolkitRuntimeException {
        int n;
        JarFile jarFile = new JarFile(artifact);
        try {
            Manifest manifest = jarFile.getManifest();
            JarEntry userEntry = Utils.getUserEntry(jarFile, manifest);
            JarEntry springStartEntry = Utils.getSpringStartEntry(jarFile, manifest);
            n = Stream.of(userEntry, springStartEntry).filter(Objects::nonNull).mapToInt(entry -> Utils.getJarEntryJavaVersion(jarFile, entry)).max().orElseThrow(() -> new AzureToolkitRuntimeException("Failed to parse artifact compile version, no valid class file founded in target artifact"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AzureToolkitRuntimeException("Failed to parse artifact compile version, no class file founded in target artifact", e);
            }
        }
        jarFile.close();
        return n;
    }

    @Nullable
    private static JarEntry getSpringStartEntry(@Nonnull JarFile jarFile, @Nonnull Manifest manifest) {
        String startClass = manifest.getMainAttributes().getValue(START_CLASS);
        String springBootClasses = Optional.ofNullable(manifest.getMainAttributes().getValue(SPRING_BOOT_CLASSES)).orElse(DEFAULT_SPRING_BOOT_CLASSES);
        return jarFile.getJarEntry(Utils.getJarEntryName(springBootClasses + startClass));
    }

    @Nullable
    private static JarEntry getUserEntry(@Nonnull JarFile jarFile, @Nonnull Manifest manifest) {
        return Optional.ofNullable(manifest.getMainAttributes().getValue(MAIN_CLASS)).map(Utils::getJarEntryName).map(jarFile::getJarEntry).orElseGet(() -> jarFile.stream().filter(entry -> StringUtils.endsWith((CharSequence)entry.getName(), (CharSequence)CLASS)).findFirst().orElse(null));
    }

    private static int getJarEntryJavaVersion(@Nonnull JarFile jarFile, @Nonnull JarEntry jarEntry) {
        int n;
        block8: {
            InputStream stream = jarFile.getInputStream(jarEntry);
            try {
                byte[] version = new byte[2];
                stream.skip(6L);
                stream.read(version);
                stream.close();
                n = new BigInteger(version).intValueExact() - 44;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AzureToolkitRuntimeException(String.format("Failed to parse compile version of entry %s", jarEntry.getName()), e);
                }
            }
            stream.close();
        }
        return n;
    }

    @Nonnull
    private static String getJarEntryName(@Nonnull String className) {
        String fullName = StringUtils.replace((String)className, (String)".", (String)"/");
        return fullName + CLASS;
    }

    public static boolean isGUID(String input) {
        try {
            return UUID.fromString(input).toString().equalsIgnoreCase(input);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    public static String getSegment(String id, String segment) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Object[] attributes = StringUtils.lowerCase((String)id).split("/");
        int pos = ArrayUtils.indexOf((Object[])attributes, (Object)StringUtils.lowerCase((String)segment));
        if (pos >= 0) {
            return attributes[pos + 1];
        }
        return null;
    }

    public static String getSubscriptionId(String resourceId) {
        return Utils.getSegment(resourceId, SUBSCRIPTIONS);
    }

    public static boolean isPomPackagingProject(String packaging) {
        return POM.equalsIgnoreCase(packaging);
    }

    public static boolean isJarPackagingProject(String packaging) {
        return JAR.equalsIgnoreCase(packaging);
    }

    public static boolean isWarPackagingProject(String packaging) {
        return WAR.equalsIgnoreCase(packaging);
    }

    public static boolean isEarPackagingProject(String packaging) {
        return EAR.equalsIgnoreCase(packaging);
    }

    public static String calcXmlIndent(String[] lines, int row, int column) {
        Preconditions.checkNotNull((Object)lines, (Object)"The parameter 'lines' cannot be null");
        Preconditions.checkArgument((lines.length > row && row >= 0 ? 1 : 0) != 0, (Object)"The parameter 'row' overflows.");
        String line = lines[row];
        Preconditions.checkArgument((line != null ? 1 : 0) != 0, (Object)("Encounter null on row: " + row));
        Preconditions.checkArgument((line.length() >= column && column >= 0 ? 1 : 0) != 0, (Object)"The parameter 'column' overflows");
        StringBuilder buffer = new StringBuilder();
        int pos = line.lastIndexOf(60, column) - 1;
        for (int i = 0; i <= pos; ++i) {
            if (line.charAt(i) == '\t') {
                buffer.append('\t');
                continue;
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String executeCommandAndGetOutput(String cmd, File cwd) throws IOException, InterruptedException {
        String[] cmds = new String[]{isWindows ? "cmd.exe" : "bash", isWindows ? "/c" : "-c", cmd};
        Process p = Runtime.getRuntime().exec(cmds, null, cwd);
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            String errorLog = IOUtils.toString((InputStream)p.getErrorStream(), (Charset)StandardCharsets.UTF_8);
            throw new CommandExecuteException(String.format("Cannot execute '%s' due to error: %s", cmd, errorLog));
        }
        return IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public static Collection<String> intersectIgnoreCase(List<String> list1, List<String> list2) {
        if (CollectionUtils.isNotEmpty(list1) && CollectionUtils.isNotEmpty(list2)) {
            return list2.stream().filter(str -> Utils.containsIgnoreCase(list1, str)).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }

    public static boolean containsIgnoreCase(List<String> list, String str) {
        if (StringUtils.isNotBlank((CharSequence)str) && CollectionUtils.isNotEmpty(list)) {
            return list.stream().anyMatch(str2 -> StringUtils.equalsIgnoreCase((CharSequence)str, (CharSequence)str2));
        }
        return false;
    }

    public static String getId(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static <K, V> Map<K, V> groupByIgnoreDuplicate(Collection<V> list, Function<? super V, ? extends K> keyMapper) {
        return list.stream().collect(Collectors.toMap(keyMapper, item -> item, (item1, item2) -> item1));
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T> T selectFirstOptionIfCurrentInvalid(String name, List<T> options, T value) {
        if (options.isEmpty()) {
            throw new AzureToolkitRuntimeException(String.format("No %s is available.", name));
        }
        return options.contains(value) ? value : options.get(0);
    }

    public static <T> void copyProperties(T to, T from, boolean whenNotSet) throws IllegalAccessException {
        for (Field field : FieldUtils.getAllFields(from.getClass())) {
            boolean isCustomObject;
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Object fromValue = FieldUtils.readField((Field)field, from, (boolean)true);
            Object toValue = FieldUtils.readField((Field)field, to, (boolean)true);
            Class<String> type = field.getType();
            boolean bl = isCustomObject = !type.getName().startsWith("java") && !type.isPrimitive() && !type.isEnum() && !type.isAssignableFrom(String.class) && !type.isArray();
            if (isCustomObject && ObjectUtils.allNotNull((Object[])new Object[]{fromValue, toValue})) {
                Utils.copyProperties(toValue, fromValue, whenNotSet);
                continue;
            }
            if (whenNotSet && toValue != null || fromValue == null) continue;
            FieldUtils.writeField((Field)field, to, (Object)fromValue, (boolean)true);
        }
    }

    @Nullable
    public static <T> T emptyToNull(T t) {
        if (t instanceof Map && MapUtils.isEmpty((Map)((Map)t)) || t instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)t)) || t instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)t))) {
            return null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUrlAccessible(@Nonnull String url, Integer ... validResponseCodes) {
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("HEAD");
            con.setReadTimeout(10000);
            boolean bl = ArrayUtils.contains((Object[])validResponseCodes, (Object)con.getResponseCode());
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            Optional.ofNullable(con).ifPresent(HttpURLConnection::disconnect);
        }
    }

    public static boolean containsIgnoreCases(@Nonnull String target, @Nonnull List<String> list) {
        return list.stream().anyMatch(item -> StringUtils.equalsIgnoreCase((CharSequence)target, (CharSequence)item));
    }

    @Nullable
    public static <T> T get(Map<String, Object> data, String path) {
        if (!path.startsWith("$.")) {
            throw new AzureToolkitRuntimeException("invalid json path");
        }
        String[] parts = path.substring(2).split("\\.");
        Object obj = data;
        for (String p : parts) {
            if (Objects.isNull(obj)) {
                return null;
            }
            Map<String, Object> d = obj;
            obj = d.get(p);
        }
        return (T)obj;
    }

    public static Path tar(final Path source, final Predicate<Path> ignore) {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("Please provide a directory.");
        }
        Path tarFilePath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(String.format("build_archive_%s.tar.gz", UUID.randomUUID()));
        try (OutputStream fOut = Files.newOutputStream(tarFilePath, new OpenOption[0]);
             BufferedOutputStream buffOut = new BufferedOutputStream(fOut);
             GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)buffOut);
             final TarArchiveOutputStream tOut = new TarArchiveOutputStream((OutputStream)gzOut);){
            tOut.setLongFileMode(3);
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isSymbolicLink() || ignore.test(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink() || ignore.test(path)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = source.relativize(path);
                    try {
                        TarArchiveEntry tarEntry = new TarArchiveEntry(path.toFile(), targetFile.toString());
                        tOut.putArchiveEntry(tarEntry);
                        Files.copy(path, (OutputStream)tOut);
                        tOut.closeArchiveEntry();
                        AzureMessager.getMessager().progress(AzureString.format("compressing : %s", path));
                    }
                    catch (IOException e) {
                        AzureMessager.getMessager().warning(AzureString.format("Unable to compress : %s", path));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    System.err.printf("Unable to tar.gz : %s%n%s%n", file, exc);
                    return FileVisitResult.CONTINUE;
                }
            });
            tOut.finish();
        }
        return tarFilePath;
    }
}

