/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UrlStreamingLog
implements StreamingLogSupport {
    private String name;
    private String endpoint;
    private String authorization;
    private Supplier<String> authorizationSupplier;

    @Override
    @NotNull
    public String getDisplayName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getId() {
        return this.endpoint;
    }

    @Override
    public String getLogStreamEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getLogStreamAuthorization() {
        return Optional.ofNullable(this.authorization).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(this.authorizationSupplier).map(Supplier::get).orElse(""));
    }

    @Generated
    private static String $default$authorization() {
        return "";
    }

    @Generated
    private static Supplier<String> $default$authorizationSupplier() {
        return () -> "";
    }

    @Generated
    public static UrlStreamingLogBuilder builder() {
        return new UrlStreamingLogBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getAuthorization() {
        return this.authorization;
    }

    @Generated
    public Supplier<String> getAuthorizationSupplier() {
        return this.authorizationSupplier;
    }

    @Generated
    public UrlStreamingLog() {
        this.authorization = UrlStreamingLog.$default$authorization();
        this.authorizationSupplier = UrlStreamingLog.$default$authorizationSupplier();
    }

    @Generated
    public UrlStreamingLog(String name, String endpoint, String authorization, Supplier<String> authorizationSupplier) {
        this.name = name;
        this.endpoint = endpoint;
        this.authorization = authorization;
        this.authorizationSupplier = authorizationSupplier;
    }

    @Generated
    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    @Generated
    public void setAuthorizationSupplier(Supplier<String> authorizationSupplier) {
        this.authorizationSupplier = authorizationSupplier;
    }

    @Generated
    public static class UrlStreamingLogBuilder {
        @Generated
        private String name;
        @Generated
        private String endpoint;
        @Generated
        private boolean authorization$set;
        @Generated
        private String authorization$value;
        @Generated
        private boolean authorizationSupplier$set;
        @Generated
        private Supplier<String> authorizationSupplier$value;

        @Generated
        UrlStreamingLogBuilder() {
        }

        @Generated
        public UrlStreamingLogBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UrlStreamingLogBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Generated
        public UrlStreamingLogBuilder authorization(String authorization) {
            this.authorization$value = authorization;
            this.authorization$set = true;
            return this;
        }

        @Generated
        public UrlStreamingLogBuilder authorizationSupplier(Supplier<String> authorizationSupplier) {
            this.authorizationSupplier$value = authorizationSupplier;
            this.authorizationSupplier$set = true;
            return this;
        }

        @Generated
        public UrlStreamingLog build() {
            String authorization$value = this.authorization$value;
            if (!this.authorization$set) {
                authorization$value = UrlStreamingLog.$default$authorization();
            }
            Supplier authorizationSupplier$value = this.authorizationSupplier$value;
            if (!this.authorizationSupplier$set) {
                authorizationSupplier$value = UrlStreamingLog.$default$authorizationSupplier();
            }
            return new UrlStreamingLog(this.name, this.endpoint, authorization$value, authorizationSupplier$value);
        }

        @Generated
        public String toString() {
            return "UrlStreamingLog.UrlStreamingLogBuilder(name=" + this.name + ", endpoint=" + this.endpoint + ", authorization$value=" + this.authorization$value + ", authorizationSupplier$value=" + this.authorizationSupplier$value + ")";
        }
    }
}

