/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationContext.class);
    private static final OperationContext NULL = new OperationContext(null);
    @Nullable
    private final Operation operation;
    private IAzureMessager messager = null;
    private final Map<String, Object> messageProperties = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> telemetryProperties = new ConcurrentHashMap<String, String>();

    public OperationContext(@Nonnull Operation operation) {
        this.operation = operation;
    }

    public void setMessageProperty(String key, String val) {
        this.messageProperties.put(key, val);
    }

    public void setTelemetryProperty(String key, String val) {
        this.telemetryProperties.put(key, val);
    }

    public void setTelemetryProperties(Map<String, String> properties) {
        this.telemetryProperties.putAll(properties);
    }

    public String getProperty(String key) {
        return this.telemetryProperties.get(key);
    }

    @Nonnull
    public IAzureMessager getMessager() {
        if (Objects.isNull(this.messager)) {
            this.messager = Optional.ofNullable(this.getParent()).map(OperationContext::getMessager).orElse(AzureMessager.getDefaultMessager());
        }
        return this.messager;
    }

    @Nonnull
    public OperationContext getAction() {
        return Optional.ofNullable(this.operation).map(Operation::getActionParent).map(Operation::getContext).orElseGet(() -> OperationContext.getNull(this.operation));
    }

    @Nullable
    public OperationContext getParent() {
        return Optional.ofNullable(this.operation).map(Operation::getParent).map(Operation::getContext).orElse(null);
    }

    @Nonnull
    public static OperationContext current() {
        Operation current = Operation.current();
        return Optional.ofNullable(current).map(Operation::getContext).orElseGet(() -> OperationContext.getNull(current));
    }

    @Nonnull
    public static OperationContext action() {
        Operation current = Operation.current();
        return Optional.of(OperationContext.current()).map(OperationContext::getAction).orElseGet(() -> OperationContext.getNull(current));
    }

    @Nonnull
    private static OperationContext getNull(@Nullable Operation operation) {
        String op = Optional.ofNullable(operation).map(Operation::getId).orElse(null);
        log.warn("default to NULL OperationContext, because operation or its action operation is null:{}", (Object)op);
        return NULL;
    }

    @Generated
    public void setMessager(IAzureMessager messager) {
        this.messager = messager;
    }

    @Generated
    public Map<String, Object> getMessageProperties() {
        return this.messageProperties;
    }

    @Generated
    public Map<String, String> getTelemetryProperties() {
        return this.telemetryProperties;
    }
}

