/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.MethodOperation;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationException;
import com.microsoft.azure.toolkit.lib.common.operation.OperationManager;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Objects;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public final class AzureOperationAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureOperationAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ AzureOperationAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.operation.AzureOperation * *..*.*(..))")
    public void operation() {
    }

    @Before(value="operation()")
    public void beforeEnter(JoinPoint point) {
        AzureOperationAspect.beforeEnter(AzureOperationAspect.toOperation(point));
    }

    @AfterReturning(value="operation()")
    public void afterReturning(JoinPoint point) {
        AzureOperationAspect.afterReturning(AzureOperationAspect.toOperation(point));
    }

    @AfterThrowing(pointcut="operation()", throwing="e")
    public void afterThrowing(JoinPoint point, Throwable e) throws Throwable {
        AzureOperationAspect.afterThrowing(e, AzureOperationAspect.toOperation(point));
    }

    public static void beforeEnter(Operation operation) {
        Object source = operation.getSource();
        if (source instanceof AzResourceModule) {
            operation.getContext().setTelemetryProperty("subscriptionId", ((AzResourceModule)source).getSubscriptionId());
        } else if (source instanceof AzResource) {
            operation.getContext().setTelemetryProperty("subscriptionId", ((AzResource)source).getSubscriptionId());
        }
        AzureTelemeter.beforeEnter(operation);
        OperationManager.getInstance().fireBeforeEnter(operation);
        OperationThreadContext.current().pushOperation(operation);
    }

    public static void afterReturning(Operation current) {
        Operation operation = OperationThreadContext.current().popOperation();
        if (operation == null) {
            return;
        }
        assert (Objects.equals(current, operation)) : String.format("popped operation[%s] is not the exiting operation[%s]", current, operation);
        OperationManager.getInstance().fireAfterReturning(operation);
        AzureTelemeter.afterExit(operation);
    }

    public static void afterThrowing(Throwable e, Operation current) throws Throwable {
        Operation operation = OperationThreadContext.current().popOperation();
        if (operation == null) {
            return;
        }
        assert (Objects.equals(current, operation)) : String.format("popped operation[%s] is not the operation[%s] throwing exception", current, operation);
        if (e instanceof OperationException || e.getClass().getName().contains("com.intellij.openapi.progress.ProcessCanceledException")) {
            throw e;
        }
        OperationManager.getInstance().fireAfterThrowing(e, operation);
        AzureTelemeter.onError(operation, e);
        if (e instanceof Exception && !(e instanceof RuntimeException)) {
            throw e;
        }
        throw new OperationException(operation, e);
    }

    public static <T> T execute(Operation operation) throws Throwable {
        Callable<?> body = operation.getBody();
        try {
            AzureOperationAspect.beforeEnter(operation);
            Object result = body.call();
            AzureOperationAspect.afterReturning(operation);
            return (T)result;
        }
        catch (Throwable e) {
            AzureOperationAspect.afterThrowing(e, operation);
            throw e;
        }
    }

    private static Operation toOperation(JoinPoint point) {
        return new MethodOperation(MethodInvocation.from(point));
    }

    static {
        try {
            AzureOperationAspect.ajc$perSingletonInstance = new AzureOperationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static AzureOperationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

