/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.resourcemanager.resources.fluent.models.SubscriptionInner;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import javax.annotation.Nonnull;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Subscription {
    public static final String MOCK_SUBSCRIPTION_ID = "00000000-0000-0000-0000-000000000000";
    public static final Subscription NONE = Subscription.builder().name(AzResource.NONE.getName()).id("00000000-0000-0000-0000-000000000000").tenantId("00000000-0000-0000-0000-000000000000").selected(true).build();
    @Nonnull
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String tenantId;
    @JsonProperty
    private boolean selected;

    public Subscription(@Nonnull String id) {
        this.id = id;
    }

    public Subscription(com.azure.resourcemanager.resources.models.Subscription s) {
        this.id = s.subscriptionId();
        this.name = s.displayName();
        this.tenantId = ((SubscriptionInner)s.innerModel()).tenantId();
    }

    @Generated
    public static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    @Nonnull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public boolean isSelected() {
        return this.selected;
    }

    @JsonProperty
    @Generated
    public void setId(@Nonnull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty
    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Generated
    public Subscription() {
    }

    @Generated
    public Subscription(@Nonnull String id, String name, String tenantId, boolean selected) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.tenantId = tenantId;
        this.selected = selected;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public static class SubscriptionBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String tenantId;
        @Generated
        private boolean selected;

        @Generated
        SubscriptionBuilder() {
        }

        @JsonProperty
        @Generated
        public SubscriptionBuilder id(@Nonnull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty
        @Generated
        public SubscriptionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @Generated
        public SubscriptionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty
        @Generated
        public SubscriptionBuilder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        @Generated
        public Subscription build() {
            return new Subscription(this.id, this.name, this.tenantId, this.selected);
        }

        @Generated
        public String toString() {
            return "Subscription.SubscriptionBuilder(id=" + this.id + ", name=" + this.name + ", tenantId=" + this.tenantId + ", selected=" + this.selected + ")";
        }
    }
}

