/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceGroupModule
extends AbstractAzResourceModule<ResourceGroup, ResourcesServiceSubscription, com.azure.resourcemanager.resources.models.ResourceGroup> {
    public static final String NAME = "resourceGroups";

    public ResourceGroupModule(@Nonnull ResourcesServiceSubscription parent) {
        super(NAME, parent);
    }

    @Override
    @Nonnull
    public List<ResourceGroup> list() {
        return super.list().stream().filter(rg -> rg.getSubscription().isSelected()).collect(Collectors.toList());
    }

    @Nonnull
    public ResourceGroup createResourceGroupIfNotExist(@Nonnull String name, @Nonnull Region region) {
        ResourceGroup group = (ResourceGroup)this.getOrDraft(name, name);
        if (group instanceof ResourceGroupDraft && !group.exists()) {
            ((ResourceGroupDraft)group).setRegion(region);
            return (ResourceGroup)((ResourceGroupDraft)group).createIfNotExist();
        }
        return group;
    }

    @Nullable
    public ResourceGroups getClient() {
        return Optional.ofNullable(((ResourcesServiceSubscription)this.parent).getRemote()).map(ResourceManager::resourceGroups).orElse(null);
    }

    public boolean exists(String resourceName) {
        return Optional.ofNullable(this.getClient()).map(c -> c.contain(resourceName)).orElse(false);
    }

    @Nonnull
    protected ResourceGroupDraft newDraftForCreate(@Nonnull String name, @Nonnull String resourceGroupName) {
        return new ResourceGroupDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected ResourceGroupDraft newDraftForUpdate(@Nonnull ResourceGroup origin) {
        return new ResourceGroupDraft(origin);
    }

    @Override
    @Nonnull
    protected ResourceGroup newResource(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup r) {
        return new ResourceGroup(r, this);
    }

    @Override
    @Nonnull
    protected ResourceGroup newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ResourceGroup(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Resource group";
    }
}

