/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.handlers.runtime;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlot;
import com.microsoft.azure.management.appservice.FunctionRuntimeStack;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.SkuName;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.legacy.appservice.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.runtime.AbstractLinuxFunctionRuntimeHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.runtime.FunctionRuntimeHandler;
import org.apache.commons.lang3.StringUtils;

public class LinuxFunctionRuntimeHandler
extends AbstractLinuxFunctionRuntimeHandler {
    protected LinuxFunctionRuntimeHandler(Builder builder) {
        super((FunctionRuntimeHandler.Builder)builder);
    }

    @Override
    public FunctionApp.DefinitionStages.WithCreate defineFunctionApp() {
        this.checkFunctionExtensionVersion();
        FunctionApp.DefinitionStages.WithDockerContainerImage withDockerContainerImage = this.defineLinuxFunction();
        return withDockerContainerImage.withBuiltInImage(this.getRuntimeStack());
    }

    @Override
    public FunctionApp.Update updateAppRuntime(FunctionApp app) {
        this.checkFunctionExtensionVersion();
        return ((FunctionApp.Update)app.update()).withBuiltInImage(this.getRuntimeStack());
    }

    @Override
    public WebAppBase.Update<FunctionDeploymentSlot> updateDeploymentSlot(FunctionDeploymentSlot deploymentSlot) {
        String targetFxVersion;
        this.checkFunctionExtensionVersion();
        PricingTier pricingTier = AppServiceUtils.getAppServicePlanByAppService((WebAppBase)deploymentSlot).pricingTier();
        String string = targetFxVersion = StringUtils.equals((CharSequence)pricingTier.toSkuDescription().tier(), (CharSequence)SkuName.DYNAMIC.toString()) ? this.getRuntimeStack().getLinuxFxVersionForConsumptionPlan() : this.getRuntimeStack().getLinuxFxVersionForDedicatedPlan();
        if (!StringUtils.equals((CharSequence)deploymentSlot.linuxFxVersion(), (CharSequence)targetFxVersion)) {
            Log.warn((String)"Updating runtime of linux deployment slot is not supported in current version");
        }
        return (WebAppBase.Update)deploymentSlot.update();
    }

    private FunctionRuntimeStack getRuntimeStack() {
        return this.javaVersion == JavaVersion.JAVA_8_NEWEST ? FunctionRuntimeStack.JAVA_8 : FunctionRuntimeStack.JAVA_11;
    }

    public static class Builder
    extends FunctionRuntimeHandler.Builder<Builder> {
        @Override
        public LinuxFunctionRuntimeHandler build() {
            return new LinuxFunctionRuntimeHandler(this.self());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

