/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.runtime;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.legacy.appservice.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.RuntimeHandler;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseRuntimeHandler<T extends WebAppBase>
implements RuntimeHandler<T> {
    private static final String TARGET_APP_SERVICE_PLAN_DO_NOT_EXIST = "Target app service plan %s cannot be found in resource group %s, please check the configuration";
    protected String appName;
    protected String resourceGroup;
    protected Region region;
    protected PricingTier pricingTier;
    protected String servicePlanName;
    protected String servicePlanResourceGroup;
    protected Azure azure;
    protected String image;
    protected String registryUrl;

    protected BaseRuntimeHandler(Builder<?> builder) {
        this.appName = builder.appName;
        this.resourceGroup = builder.resourceGroup;
        this.region = builder.region;
        this.pricingTier = builder.pricingTier;
        this.servicePlanName = builder.servicePlanName;
        this.servicePlanResourceGroup = builder.servicePlanResourceGroup;
        this.azure = builder.azure;
        this.image = builder.image;
        this.registryUrl = builder.registryUrl;
    }

    @Override
    public abstract WebAppBase.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException;

    @Override
    public abstract WebAppBase.Update updateAppRuntime(T var1) throws AzureExecutionException;

    protected abstract void changeAppServicePlan(T var1, AppServicePlan var2) throws AzureExecutionException;

    @Override
    public AppServicePlan updateAppServicePlan(T app) throws AzureExecutionException {
        AppServicePlan targetAppServicePlan;
        AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlanByAppService(app);
        AppServicePlan appServicePlan2 = targetAppServicePlan = StringUtils.isNotEmpty((CharSequence)this.servicePlanName) ? this.getAppServicePlan() : appServicePlan;
        if (targetAppServicePlan == null) {
            throw new AzureExecutionException(String.format(TARGET_APP_SERVICE_PLAN_DO_NOT_EXIST, this.servicePlanName, AppServiceUtils.getAppServicePlanResourceGroup(this.resourceGroup, this.servicePlanResourceGroup)));
        }
        if (!AppServiceUtils.isEqualAppServicePlan(appServicePlan, targetAppServicePlan)) {
            this.changeAppServicePlan(app, targetAppServicePlan);
        }
        return AppServiceUtils.updateAppServicePlan(targetAppServicePlan, this.pricingTier);
    }

    protected AppServicePlan getAppServicePlan() {
        return AppServiceUtils.getAppServicePlan(this.servicePlanName, this.azure, this.resourceGroup, this.servicePlanResourceGroup);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String appName;
        protected String resourceGroup;
        protected Region region;
        protected PricingTier pricingTier;
        protected String servicePlanName;
        protected String servicePlanResourceGroup;
        protected Azure azure;
        protected String image;
        protected String registryUrl;

        public T appName(String value) {
            this.appName = value;
            return this.self();
        }

        public T resourceGroup(String value) {
            this.resourceGroup = value;
            return this.self();
        }

        public T region(Region value) {
            this.region = value;
            return this.self();
        }

        public T pricingTier(PricingTier value) {
            this.pricingTier = value;
            return this.self();
        }

        public T servicePlanName(String value) {
            this.servicePlanName = value;
            return this.self();
        }

        public T servicePlanResourceGroup(String value) {
            this.servicePlanResourceGroup = value;
            return this.self();
        }

        public T azure(Azure value) {
            this.azure = value;
            return this.self();
        }

        public T image(String value) {
            this.image = value;
            return this.self();
        }

        public T registryUrl(String value) {
            this.registryUrl = value;
            return this.self();
        }

        public abstract BaseRuntimeHandler build();

        protected abstract T self();
    }
}

