/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeployTarget;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact.ArtifactHandlerBase;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact.FTPUploader;

public class FTPArtifactHandlerImpl
extends ArtifactHandlerBase {
    private static final String DEFAULT_WEBAPP_ROOT = "/site/wwwroot";
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;

    private FTPArtifactHandlerImpl(Builder builder) {
        super(builder);
    }

    public void publish(DeployTarget target) throws AzureExecutionException {
        this.assureStagingDirectoryNotEmpty();
        Log.prompt((String)String.format("Trying to deploy artifact to %s...", target.getName()));
        this.uploadDirectoryToFTP(target);
        if (target.getApp() instanceof FunctionApp) {
            ((FunctionApp)target.getApp()).syncTriggers();
        }
        Log.prompt((String)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
    }

    protected void uploadDirectoryToFTP(DeployTarget target) throws AzureExecutionException {
        FTPUploader uploader = this.getUploader();
        PublishingProfile profile = target.getPublishingProfile();
        String serverUrl = profile.ftpUrl().split("/", 2)[0];
        uploader.uploadDirectoryWithRetries(serverUrl, profile.ftpUsername(), profile.ftpPassword(), this.stagingDirectoryPath, DEFAULT_WEBAPP_ROOT, 3);
    }

    protected FTPUploader getUploader() {
        return new FTPUploader();
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FTPArtifactHandlerImpl build() {
            return new FTPArtifactHandlerImpl(this);
        }
    }
}

