/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact;

import com.microsoft.azure.toolkit.lib.common.IProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.ArtifactHandler;
import java.io.File;

public abstract class ArtifactHandlerBase
implements ArtifactHandler {
    protected static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    protected static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    protected static final String DEPLOY_ABORT = "Deployment is aborted.";
    protected static final String STAGING_FOLDER_EMPTY = "Staging directory: '%s' is empty, please check your <resources> configuration.(Have you executed mvn package before this command?)";
    protected IProject project;
    protected String stagingDirectoryPath;
    protected String buildDirectoryAbsolutePath;

    protected ArtifactHandlerBase(Builder<?> builder) {
        this.project = ((Builder)builder).project;
        this.stagingDirectoryPath = ((Builder)builder).stagingDirectoryPath;
        this.buildDirectoryAbsolutePath = ((Builder)builder).buildDirectoryAbsolutePath;
    }

    protected void assureStagingDirectoryNotEmpty() throws AzureExecutionException {
        File stagingDirectory = new File(this.stagingDirectoryPath);
        File[] files = stagingDirectory.listFiles();
        if (!stagingDirectory.exists() || !stagingDirectory.isDirectory() || files == null || files.length == 0) {
            throw new AzureExecutionException(String.format(STAGING_FOLDER_EMPTY, stagingDirectory.getAbsolutePath()));
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private IProject project;
        private String stagingDirectoryPath;
        private String buildDirectoryAbsolutePath;

        protected abstract T self();

        public abstract ArtifactHandlerBase build();

        public T project(IProject value) {
            this.project = value;
            return this.self();
        }

        public T stagingDirectoryPath(String value) {
            this.stagingDirectoryPath = value;
            return this.self();
        }

        public T buildDirectoryAbsolutePath(String value) {
            this.buildDirectoryAbsolutePath = value;
            return this.self();
        }
    }
}

