/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy;

import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact.FTPUploader;
import java.io.File;

public class FTPFunctionDeployHandler
implements IFunctionDeployHandler {
    private static final String DEFAULT_WEBAPP_ROOT = "/site/wwwroot";
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;

    @Override
    public void deploy(File file, WebAppBase webAppBase) {
        FTPUploader uploader = new FTPUploader();
        PublishingProfile profile = webAppBase.getPublishingProfile();
        String serverUrl = profile.ftpUrl().split("/", 2)[0];
        try {
            uploader.uploadDirectoryWithRetries(serverUrl, profile.ftpUsername(), profile.ftpPassword(), file.getAbsolutePath(), DEFAULT_WEBAPP_ROOT, 3);
        }
        catch (AzureExecutionException e) {
            throw new AzureToolkitRuntimeException("Failed to upload artifact to azure", (Throwable)e);
        }
        if (webAppBase instanceof FunctionApp) {
            ((FunctionApp)webAppBase).syncTriggers();
        }
        AzureMessager.getMessager().info(String.format("Successfully deployed the artifact to https://%s", webAppBase.defaultHostname()));
    }
}

