/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WebAppDeploymentSlot
extends AbstractAppService<DeploymentSlot, WebAppDeploymentSlotEntity>
implements IWebAppDeploymentSlot {
    private final AzureResourceManager azureClient;

    public WebAppDeploymentSlot(WebAppDeploymentSlotEntity deploymentSlot, AzureResourceManager azureClient) {
        this.entity = deploymentSlot;
        this.azureClient = azureClient;
    }

    @Override
    public IWebApp webApp() {
        WebAppDeploymentSlotEntity entity = (WebAppDeploymentSlotEntity)this.entity();
        return ((AzureAppService)Azure.az(AzureAppService.class)).webapp(entity.getSubscriptionId(), entity.getResourceGroup(), entity.getWebappName());
    }

    @Override
    public IWebAppDeploymentSlot.Creator create() {
        return new WebAppDeploymentSlotCreator();
    }

    @Override
    public IWebAppDeploymentSlot.Updater update() {
        return new WebAppDeploymentSlotUpdater();
    }

    @Override
    @NotNull
    protected WebAppDeploymentSlotEntity getEntityFromRemoteResource(@NotNull DeploymentSlot remote) {
        return AppServiceUtils.fromWebAppDeploymentSlot(remote);
    }

    @Override
    protected DeploymentSlot remote() {
        WebApp parentWebApp = this.getParentWebApp();
        return StringUtils.isNotEmpty((CharSequence)((WebAppDeploymentSlotEntity)this.entity).getId()) ? (DeploymentSlot)parentWebApp.deploymentSlots().getById(((WebAppDeploymentSlotEntity)this.entity).getId()) : (DeploymentSlot)parentWebApp.deploymentSlots().getByName(((WebAppDeploymentSlotEntity)this.entity).getName());
    }

    @Override
    public void delete() {
        ((WebApp)((DeploymentSlot)this.getRemoteResource()).parent()).deploymentSlots().deleteByName(((WebAppDeploymentSlotEntity)this.entity).getName());
    }

    @Override
    public void deploy(com.microsoft.azure.toolkit.lib.appservice.model.DeployType deployType, File targetFile, String targetPath) {
        DeployOptions options = new DeployOptions().withPath(targetPath);
        ((DeploymentSlot)this.getRemoteResource()).deploy(DeployType.fromString((String)deployType.getValue()), targetFile, options);
    }

    private WebApp getParentWebApp() {
        return StringUtils.isNotEmpty((CharSequence)((WebAppDeploymentSlotEntity)this.entity).getId()) ? (WebApp)this.azureClient.webApps().getById(ResourceId.fromString((String)((WebAppDeploymentSlotEntity)this.entity).getId()).parent().id()) : (WebApp)this.azureClient.webApps().getByResourceGroup(((WebAppDeploymentSlotEntity)this.entity).getResourceGroup(), ((WebAppDeploymentSlotEntity)this.entity).getWebappName());
    }

    private class WebAppDeploymentSlotUpdater
    implements IWebAppDeploymentSlot.Updater {
        private final List<String> appSettingsToRemove = new ArrayList<String>();
        private final Map<String, String> appSettingsToAdd = new HashMap<String, String>();
        private DiagnosticConfig diagnosticConfig = null;

        private WebAppDeploymentSlotUpdater() {
        }

        @Override
        public IWebAppDeploymentSlot.Updater withoutAppSettings(String key) {
            this.appSettingsToRemove.add(key);
            return this;
        }

        @Override
        public WebAppDeploymentSlotUpdater withAppSettings(Map<String, String> appSettings) {
            this.appSettingsToAdd.putAll(appSettings);
            return this;
        }

        @Override
        public WebAppDeploymentSlotUpdater withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        @Override
        public WebAppDeploymentSlot commit() {
            DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)((DeploymentSlot)WebAppDeploymentSlot.this.getRemoteResource()).update();
            if (this.getAppSettingsToAdd() != null) {
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (this.getAppSettingsToRemove() != null) {
                this.getAppSettingsToRemove().forEach(arg_0 -> ((DeploymentSlotBase.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase((WebAppBase.Update)update, this.getDiagnosticConfig());
            }
            WebAppDeploymentSlot.this.remote = (WebAppBase)update.apply();
            WebAppDeploymentSlot.this.entity = AppServiceUtils.fromWebAppDeploymentSlot((DeploymentSlot)WebAppDeploymentSlot.this.remote);
            return WebAppDeploymentSlot.this;
        }

        public List<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettingsToAdd() {
            return this.appSettingsToAdd;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }

    public class WebAppDeploymentSlotCreator
    implements IWebAppDeploymentSlot.Creator {
        public static final String CONFIGURATION_SOURCE_NEW = "new";
        public static final String CONFIGURATION_SOURCE_PARENT = "parent";
        private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current web app";
        private static final String FAILED_TO_GET_CONFIGURATION_SOURCE = "Failed to get configuration source slot";
        private String name;
        private String configurationSource = "parent";
        private Map<String, String> appSettings = null;
        private DiagnosticConfig diagnosticConfig = null;

        @Override
        public IWebAppDeploymentSlot.Creator withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IWebAppDeploymentSlot.Creator withAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
            return this;
        }

        @Override
        public IWebAppDeploymentSlot.Creator withConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        @Override
        public IWebAppDeploymentSlot.Creator withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        @Override
        public WebAppDeploymentSlot commit() {
            DeploymentSlot.DefinitionStages.WithCreate withCreate;
            String source;
            WebApp webApp = WebAppDeploymentSlot.this.getParentWebApp();
            DeploymentSlot.DefinitionStages.Blank blank = (DeploymentSlot.DefinitionStages.Blank)webApp.deploymentSlots().define(this.getName());
            switch (source = StringUtils.isEmpty((CharSequence)this.configurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)this.configurationSource)) {
                case "new": {
                    withCreate = blank.withBrandNewConfiguration();
                    break;
                }
                case "parent": {
                    withCreate = blank.withConfigurationFromParent();
                    break;
                }
                default: {
                    try {
                        DeploymentSlot deploymentSlot = Optional.ofNullable((DeploymentSlot)webApp.deploymentSlots().getByName(this.configurationSource)).orElseThrow(() -> new AzureToolkitRuntimeException(CONFIGURATION_SOURCE_DOES_NOT_EXISTS));
                        withCreate = blank.withConfigurationFromDeploymentSlot(deploymentSlot);
                        break;
                    }
                    catch (ManagementException e) {
                        throw new AzureToolkitRuntimeException(FAILED_TO_GET_CONFIGURATION_SOURCE, (Throwable)e);
                    }
                }
            }
            if (this.getAppSettings() != null) {
                withCreate.withAppSettings(this.getAppSettings());
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase((WebAppBase.DefinitionStages.WithCreate)withCreate, this.getDiagnosticConfig());
            }
            WebAppDeploymentSlot.this.remote = (WebAppBase)withCreate.create();
            WebAppDeploymentSlot.this.entity = AppServiceUtils.fromWebAppDeploymentSlot((DeploymentSlot)WebAppDeploymentSlot.this.remote);
            return WebAppDeploymentSlot.this;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }
}

