/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionAppDeploymentSlot
extends FunctionAppBase<FunctionDeploymentSlot, FunctionAppDeploymentSlotEntity>
implements IFunctionAppDeploymentSlot {
    private final AzureResourceManager azureClient;

    public FunctionAppDeploymentSlot(FunctionAppDeploymentSlotEntity deploymentSlot, AzureResourceManager azureClient) {
        this.entity = deploymentSlot;
        this.azureClient = azureClient;
    }

    @Override
    public IFunctionApp functionApp() {
        return ((AzureAppService)Azure.az(AzureAppService.class)).functionApp(((FunctionAppDeploymentSlotEntity)this.entity()).getResourceGroup(), ((FunctionAppDeploymentSlotEntity)this.entity()).getFunctionAppName());
    }

    @Override
    public IFunctionAppDeploymentSlot.Creator create() {
        return new FunctionAppDeploymentSlotCreator();
    }

    @Override
    public IFunctionAppDeploymentSlot.Updater update() {
        return new FunctionAppDeploymentSlotUpdater();
    }

    @Override
    @NotNull
    protected FunctionAppDeploymentSlotEntity getEntityFromRemoteResource(@NotNull FunctionDeploymentSlot remote) {
        return AppServiceUtils.fromFunctionAppDeploymentSlot(remote);
    }

    @Override
    public void delete() {
        this.getParentFunctionApp().deploymentSlots().deleteById(((FunctionDeploymentSlot)this.getRemoteResource()).id());
    }

    @Override
    @Nullable
    protected FunctionDeploymentSlot remote() {
        FunctionApp parentFunctionApp = this.getParentFunctionApp();
        return StringUtils.isNotEmpty((CharSequence)((FunctionAppDeploymentSlotEntity)this.entity).getId()) ? (FunctionDeploymentSlot)parentFunctionApp.deploymentSlots().getById(((FunctionAppDeploymentSlotEntity)this.entity).getId()) : (FunctionDeploymentSlot)parentFunctionApp.deploymentSlots().getByName(((FunctionAppDeploymentSlotEntity)this.entity).getName());
    }

    private FunctionApp getParentFunctionApp() {
        return StringUtils.isNotEmpty((CharSequence)((FunctionAppDeploymentSlotEntity)this.entity).getId()) ? (FunctionApp)this.azureClient.functionApps().getById(ResourceId.fromString((String)((FunctionAppDeploymentSlotEntity)this.entity).getId()).parent().id()) : (FunctionApp)this.azureClient.functionApps().getByResourceGroup(((FunctionAppDeploymentSlotEntity)this.entity).getResourceGroup(), ((FunctionAppDeploymentSlotEntity)this.entity).getFunctionAppName());
    }

    private class FunctionAppDeploymentSlotUpdater
    implements IFunctionAppDeploymentSlot.Updater {
        private final List<String> appSettingsToRemove = new ArrayList<String>();
        private final Map<String, String> appSettingsToAdd = new HashMap<String, String>();
        private DiagnosticConfig diagnosticConfig = null;

        private FunctionAppDeploymentSlotUpdater() {
        }

        @Override
        public IFunctionAppDeploymentSlot.Updater withoutAppSettings(String key) {
            this.appSettingsToRemove.add(key);
            return this;
        }

        @Override
        public IFunctionAppDeploymentSlot.Updater withAppSettings(Map<String, String> appSettings) {
            this.appSettingsToAdd.putAll(appSettings);
            return this;
        }

        @Override
        public IFunctionAppDeploymentSlot.Updater withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        @Override
        public FunctionAppDeploymentSlot commit() {
            DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)((FunctionDeploymentSlot)FunctionAppDeploymentSlot.this.getRemoteResource()).update();
            if (this.getAppSettingsToAdd() != null) {
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (this.getAppSettingsToRemove() != null) {
                this.getAppSettingsToRemove().forEach(arg_0 -> ((DeploymentSlotBase.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase((WebAppBase.Update)update, this.getDiagnosticConfig());
            }
            FunctionAppDeploymentSlot.this.remote = (WebAppBase)update.apply();
            FunctionAppDeploymentSlot.this.entity = AppServiceUtils.fromFunctionAppDeploymentSlot((FunctionDeploymentSlot)FunctionAppDeploymentSlot.this.remote);
            return FunctionAppDeploymentSlot.this;
        }

        public List<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettingsToAdd() {
            return this.appSettingsToAdd;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }

    public class FunctionAppDeploymentSlotCreator
    implements IFunctionAppDeploymentSlot.Creator {
        public static final String CONFIGURATION_SOURCE_NEW = "new";
        public static final String CONFIGURATION_SOURCE_PARENT = "parent";
        private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current web app";
        private static final String FAILED_TO_GET_CONFIGURATION_SOURCE = "Failed to get configuration source slot";
        private String name;
        private String configurationSource = "parent";
        private Map<String, String> appSettings = null;
        private DiagnosticConfig diagnosticConfig = null;

        @Override
        public IFunctionAppDeploymentSlot.Creator withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IFunctionAppDeploymentSlot.Creator withAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
            return this;
        }

        @Override
        public IFunctionAppDeploymentSlot.Creator withConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        @Override
        public IFunctionAppDeploymentSlot.Creator withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this;
        }

        @Override
        public IFunctionAppDeploymentSlot commit() {
            FunctionDeploymentSlot.DefinitionStages.WithCreate withCreate;
            String source;
            FunctionApp functionApp = FunctionAppDeploymentSlot.this.getParentFunctionApp();
            FunctionDeploymentSlot.DefinitionStages.Blank blank = (FunctionDeploymentSlot.DefinitionStages.Blank)functionApp.deploymentSlots().define(this.getName());
            switch (source = StringUtils.isEmpty((CharSequence)this.configurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)this.configurationSource)) {
                case "new": {
                    withCreate = blank.withBrandNewConfiguration();
                    break;
                }
                case "parent": {
                    withCreate = blank.withConfigurationFromParent();
                    break;
                }
                default: {
                    try {
                        FunctionDeploymentSlot deploymentSlot = Optional.ofNullable((FunctionDeploymentSlot)functionApp.deploymentSlots().getByName(this.configurationSource)).orElseThrow(() -> new AzureToolkitRuntimeException(CONFIGURATION_SOURCE_DOES_NOT_EXISTS));
                        withCreate = blank.withConfigurationFromDeploymentSlot(deploymentSlot);
                        break;
                    }
                    catch (ManagementException e) {
                        throw new AzureToolkitRuntimeException(FAILED_TO_GET_CONFIGURATION_SOURCE, (Throwable)e);
                    }
                }
            }
            if (this.getAppSettings() != null) {
                withCreate.withAppSettings(this.getAppSettings());
            }
            if (this.getDiagnosticConfig() != null) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase((WebAppBase.DefinitionStages.WithCreate)withCreate, this.getDiagnosticConfig());
            }
            FunctionAppDeploymentSlot.this.remote = (WebAppBase)withCreate.create();
            FunctionAppDeploymentSlot.this.entity = AppServiceUtils.fromFunctionAppDeploymentSlot((FunctionDeploymentSlot)FunctionAppDeploymentSlot.this.remote);
            return FunctionAppDeploymentSlot.this;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }
    }
}

