/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceCreator;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceCreator;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import io.jsonwebtoken.lang.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FunctionApp
extends FunctionAppBase<com.azure.resourcemanager.appservice.models.FunctionApp, FunctionAppEntity>
implements IFunctionApp {
    public static final JavaVersion DEFAULT_JAVA_VERSION = JavaVersion.JAVA_8;
    private static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    private final AzureResourceManager azureClient;

    public FunctionApp(FunctionAppEntity entity, AzureResourceManager azureClient) {
        this.entity = entity;
        this.azureClient = azureClient;
    }

    @Override
    public IAppServicePlan plan() {
        return ((AzureAppService)Azure.az(AzureAppService.class)).appServicePlan(((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).appServicePlanId());
    }

    @Override
    public IAppServiceCreator<? extends IFunctionApp> create() {
        return new FunctionAppCreator();
    }

    @Override
    public IAppServiceUpdater<? extends IFunctionApp> update() {
        return new FunctionAppUpdater();
    }

    @Override
    public IFunctionAppDeploymentSlot deploymentSlot(String slotName) {
        AppServiceBaseEntity slotEntity = ((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((AppServiceBaseEntity.AppServiceBaseEntityBuilder)FunctionAppDeploymentSlotEntity.builder().functionAppName(this.name())).resourceGroup(((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).resourceGroupName())).name(slotName)).build();
        return new FunctionAppDeploymentSlot((FunctionAppDeploymentSlotEntity)slotEntity, this.azureClient);
    }

    @Override
    public List<IFunctionAppDeploymentSlot> deploymentSlots() {
        return ((Stream)((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).deploymentSlots().list().stream().parallel()).map(functionSlotBasic -> ((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)FunctionAppDeploymentSlotEntity.builder().id(functionSlotBasic.id())).build()).map(slotEntity -> new FunctionAppDeploymentSlot((FunctionAppDeploymentSlotEntity)slotEntity, this.azureClient)).collect(Collectors.toList());
    }

    @Override
    public List<FunctionEntity> listFunctions() {
        return this.azureClient.functionApps().listFunctions(((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).resourceGroupName(), ((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).name()).stream().map(AppServiceUtils::fromFunctionAppEnvelope).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void triggerFunction(String functionName) {
        throw new NotImplementedException();
    }

    @Override
    public void swap(String slotName) {
        ((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).swap(slotName);
    }

    @Override
    public void syncTriggers() {
        ((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).syncTriggers();
    }

    @Override
    public void delete() {
        this.azureClient.functionApps().deleteById(((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemoteResource()).id());
    }

    @Override
    @Nonnull
    protected FunctionAppEntity getEntityFromRemoteResource(@NotNull com.azure.resourcemanager.appservice.models.FunctionApp remote) {
        return AppServiceUtils.fromFunctionApp(remote);
    }

    @Override
    @Nullable
    protected com.azure.resourcemanager.appservice.models.FunctionApp remote() {
        return StringUtils.isNotEmpty((CharSequence)((FunctionAppEntity)this.entity).getId()) ? (com.azure.resourcemanager.appservice.models.FunctionApp)this.azureClient.functionApps().getById(((FunctionAppEntity)this.entity).getId()) : (com.azure.resourcemanager.appservice.models.FunctionApp)this.azureClient.functionApps().getByResourceGroup(((FunctionAppEntity)this.entity).getResourceGroup(), ((FunctionAppEntity)this.entity).getName());
    }

    public class FunctionAppUpdater
    extends AbstractAppServiceUpdater<FunctionApp> {
        public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system for existing app service";
        private boolean modified = false;

        public FunctionApp commit() {
            FunctionApp.Update update = (FunctionApp.Update)((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.getRemoteResource()).update();
            if (this.getAppServicePlan() != null && this.getAppServicePlan().isPresent()) {
                update = this.updateAppServicePlan(update, this.getAppServicePlan().get());
            }
            if (this.getRuntime() != null && this.getRuntime().isPresent()) {
                update = this.updateRuntime(update, this.getRuntime().get());
            }
            if (!Collections.isEmpty(this.getAppSettingsToAdd())) {
                this.modified = true;
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (!Collections.isEmpty(this.getAppSettingsToRemove())) {
                this.modified = true;
                this.getAppSettingsToRemove().forEach(arg_0 -> ((FunctionApp.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                this.modified = true;
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase((WebAppBase.Update)update, this.getDiagnosticConfig().get());
            }
            if (this.modified) {
                FunctionApp.this.remote = (WebAppBase)update.apply();
            }
            FunctionApp.this.entity = AppServiceUtils.fromFunctionApp((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.remote);
            return FunctionApp.this;
        }

        private FunctionApp.Update updateAppServicePlan(FunctionApp.Update update, AppServicePlanEntity newServicePlan) {
            String servicePlanId = ((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.getRemoteResource()).appServicePlanId();
            AppServicePlanEntity currentServicePlan = ((AzureAppService)Azure.az(AzureAppService.class)).appServicePlan(servicePlanId).entity();
            if (StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getId(), (CharSequence)newServicePlan.getId()) || StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getName(), (CharSequence)newServicePlan.getName()) && StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getResourceGroup(), (CharSequence)newServicePlan.getResourceGroup())) {
                return update;
            }
            AppServicePlan newPlanServiceModel = AppServiceUtils.getAppServicePlan(newServicePlan, FunctionApp.this.azureClient);
            if (newPlanServiceModel == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            this.modified = true;
            return update.withExistingAppServicePlan(newPlanServiceModel);
        }

        private FunctionApp.Update updateRuntime(FunctionApp.Update update, Runtime newRuntime) {
            Runtime current = FunctionApp.this.getRuntime();
            if (Objects.equals(current, newRuntime)) {
                return update;
            }
            if (newRuntime.getOperatingSystem() != null && current.getOperatingSystem() != newRuntime.getOperatingSystem()) {
                throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
            }
            this.modified = true;
            OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), current.getOperatingSystem()}));
            switch (operatingSystem) {
                case LINUX: {
                    return update.withBuiltInImage(AppServiceUtils.toFunctionRuntimeStack(newRuntime));
                }
                case WINDOWS: {
                    return this.updateWindowsFunctionApp(update, current, newRuntime);
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()})) {
                        return update.withPublicDockerHubImage(dockerConfiguration.getImage());
                    }
                    if (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl())) {
                        return update.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
                    }
                    return update.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
                }
            }
            throw new AzureToolkitRuntimeException(String.format(FunctionApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }

        FunctionApp.Update updateWindowsFunctionApp(FunctionApp.Update update, Runtime currentRuntime, Runtime newRuntime) {
            if (currentRuntime.getJavaVersion() == JavaVersion.OFF) {
                JavaVersion javaVersion = Optional.ofNullable(newRuntime.getJavaVersion()).orElse(DEFAULT_JAVA_VERSION);
                return (FunctionApp.Update)update.withJavaVersion(AppServiceUtils.toJavaVersion(javaVersion)).withWebContainer(null);
            }
            if (newRuntime.getJavaVersion() != JavaVersion.OFF && newRuntime.getJavaVersion() != currentRuntime.getJavaVersion()) {
                return (FunctionApp.Update)update.withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(null);
            }
            return update;
        }
    }

    public class FunctionAppCreator
    extends AbstractAppServiceCreator<FunctionApp> {
        public static final String APP_SETTING_MACHINEKEY_DECRYPTION_KEY = "MACHINEKEY_DecryptionKey";
        public static final String APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE = "WEBSITES_ENABLE_APP_SERVICE_STORAGE";
        public static final String APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE = "false";
        public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE = "FUNCTION_APP_EDIT_MODE";
        public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY = "readOnly";

        @Override
        public FunctionApp commit() {
            FunctionApp.DefinitionStages.WithCreate withCreate;
            FunctionApp.DefinitionStages.Blank blank = (FunctionApp.DefinitionStages.Blank)FunctionApp.this.azureClient.functionApps().define(this.getName());
            Runtime runtime = this.getRuntime();
            AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlan(this.getAppServicePlanEntity(), FunctionApp.this.azureClient);
            if (appServicePlan == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            ResourceGroup resourceGroup = (ResourceGroup)FunctionApp.this.azureClient.resourceGroups().getByName(this.getResourceGroup());
            switch (runtime.getOperatingSystem()) {
                case LINUX: {
                    withCreate = this.createLinuxFunctionApp(blank, resourceGroup, appServicePlan, runtime);
                    break;
                }
                case WINDOWS: {
                    withCreate = this.createWindowsFunctionApp(blank, resourceGroup, appServicePlan, runtime);
                    break;
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    withCreate = this.createDockerFunctionApp(blank, resourceGroup, appServicePlan, dockerConfiguration);
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException(String.format(FunctionApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{runtime.getOperatingSystem()}));
                }
            }
            if (this.getAppSettings() != null && this.getAppSettings().isPresent()) {
                withCreate.withAppSettings(this.getAppSettings().get());
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase((WebAppBase.DefinitionStages.WithCreate)withCreate, this.getDiagnosticConfig().get());
            }
            FunctionApp.this.remote = (WebAppBase)withCreate.create();
            FunctionApp.this.entity = AppServiceUtils.fromFunctionApp((com.azure.resourcemanager.appservice.models.FunctionApp)FunctionApp.this.remote);
            return FunctionApp.this;
        }

        FunctionApp.DefinitionStages.WithCreate createWindowsFunctionApp(FunctionApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, Runtime runtime) {
            return (FunctionApp.DefinitionStages.WithCreate)((FunctionApp.DefinitionStages.WithCreate)blank.withExistingAppServicePlan(appServicePlan).withExistingResourceGroup(resourceGroup)).withJavaVersion(AppServiceUtils.toWindowsJavaVersion(runtime)).withWebContainer(null);
        }

        FunctionApp.DefinitionStages.WithCreate createLinuxFunctionApp(FunctionApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, Runtime runtime) {
            return blank.withExistingLinuxAppServicePlan(appServicePlan).withExistingResourceGroup(resourceGroup).withBuiltInImage(AppServiceUtils.toFunctionRuntimeStack(runtime));
        }

        FunctionApp.DefinitionStages.WithCreate createDockerFunctionApp(FunctionApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, DockerConfiguration dockerConfiguration) {
            if (StringUtils.equalsIgnoreCase((CharSequence)appServicePlan.pricingTier().toSkuDescription().tier(), (CharSequence)"Dynamic")) {
                throw new AzureToolkitRuntimeException("Docker function is not supported in consumption service plan");
            }
            FunctionApp.DefinitionStages.WithDockerContainerImage withLinuxAppFramework = blank.withExistingLinuxAppServicePlan(appServicePlan).withExistingResourceGroup(resourceGroup);
            FunctionApp.DefinitionStages.WithCreate withCreate = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(dockerConfiguration.getImage()) : (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()));
            String decryptionKey = this.generateDecryptionKey();
            return (FunctionApp.DefinitionStages.WithCreate)withCreate.withAppSetting(APP_SETTING_MACHINEKEY_DECRYPTION_KEY, decryptionKey).withAppSetting(APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE, APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE).withAppSetting(APP_SETTING_FUNCTION_APP_EDIT_MODE, APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY);
        }

        protected String generateDecryptionKey() {
            return Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)32)).toUpperCase();
        }
    }
}

