/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.fluent.models.FunctionEnvelopeInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemHttpLogsConfig;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.azure.resourcemanager.appservice.models.FunctionRuntimeStack;
import com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.RuntimeStack;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.azure.resourcemanager.appservice.models.WebAppDiagnosticLogs;
import com.azure.resourcemanager.appservice.models.WebContainer;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.LogLevel;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

class AppServiceUtils {
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String ENTRY_POINT = "entryPoint";
    private static final String BINDINGS = "bindings";

    AppServiceUtils() {
    }

    static Runtime getRuntimeFromAppService(WebAppBase webAppBase) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)webAppBase.linuxFxVersion(), (CharSequence)"docker")) {
            return Runtime.DOCKER;
        }
        return webAppBase.operatingSystem() == OperatingSystem.WINDOWS ? AppServiceUtils.getRuntimeFromWindowsAppService(webAppBase) : AppServiceUtils.getRuntimeFromLinuxAppService(webAppBase);
    }

    private static Runtime getRuntimeFromLinuxAppService(WebAppBase webAppBase) {
        if (StringUtils.isEmpty((CharSequence)webAppBase.linuxFxVersion())) {
            return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.OFF);
        }
        String linuxFxVersion = webAppBase.linuxFxVersion().replace("|", " ");
        return StringUtils.containsIgnoreCase((CharSequence)((SiteInner)webAppBase.innerModel()).kind(), (CharSequence)"function") ? AppServiceUtils.getRuntimeFromLinuxFunctionApp(linuxFxVersion) : AppServiceUtils.getRuntimeFromLinuxWebApp(linuxFxVersion);
    }

    private static Runtime getRuntimeFromLinuxWebApp(String linuxFxVersion) {
        return Runtime.getRuntimeFromLinuxFxVersion(linuxFxVersion);
    }

    private static Runtime getRuntimeFromLinuxFunctionApp(String linuxFxVersion) {
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.fromString(linuxFxVersion);
        return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF, javaVersion);
    }

    private static Runtime getRuntimeFromWindowsAppService(WebAppBase webAppBase) {
        if (webAppBase.javaVersion() == null || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{webAppBase.javaContainer(), webAppBase.javaContainerVersion()})) {
            return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS, com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF, com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.OFF);
        }
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.values().stream().filter(version -> StringUtils.equals((CharSequence)webAppBase.javaVersion().toString(), (CharSequence)version.getValue())).findFirst().orElse(com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.OFF);
        String javaContainer = String.join((CharSequence)" ", webAppBase.javaContainer(), webAppBase.javaContainerVersion());
        com.microsoft.azure.toolkit.lib.appservice.model.WebContainer webContainer = StringUtils.equalsIgnoreCase((CharSequence)webAppBase.javaContainer(), (CharSequence)"java") ? com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_SE : com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.values().stream().filter(container -> StringUtils.equalsIgnoreCase((CharSequence)javaContainer, (CharSequence)container.getValue())).findFirst().orElse(com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_OFF);
        return Runtime.getRuntime(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS, webContainer, javaVersion);
    }

    static RuntimeStack toLinuxRuntimeStack(Runtime runtime) {
        return RuntimeStack.getAll().stream().filter(runtimeStack -> {
            Runtime stackRuntime = Runtime.getRuntimeFromLinuxFxVersion(runtimeStack.toString());
            return stackRuntime != null && Objects.equals(stackRuntime.getJavaVersion(), runtime.getJavaVersion()) && Objects.equals(stackRuntime.getWebContainer(), runtime.getWebContainer());
        }).findFirst().orElse(null);
    }

    static FunctionRuntimeStack toFunctionRuntimeStack(@Nonnull Runtime runtime) {
        if (runtime.getOperatingSystem() != com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX) {
            throw new AzureToolkitRuntimeException(String.format("Can not convert %s runtime to FunctionRuntimeStack", new Object[]{runtime.getOperatingSystem()}));
        }
        return runtime.getJavaVersion() == com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_8 ? FunctionRuntimeStack.JAVA_8 : FunctionRuntimeStack.JAVA_11;
    }

    static WebContainer toWindowsWebContainer(Runtime runtime) {
        if (runtime.getWebContainer() == com.microsoft.azure.toolkit.lib.appservice.model.WebContainer.JAVA_SE) {
            return StringUtils.startsWith((CharSequence)runtime.getJavaVersion().getValue(), (CharSequence)com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_8.getValue()) ? WebContainer.JAVA_8 : WebContainer.fromString((String)"java 11");
        }
        return WebContainer.values().stream().filter(container -> StringUtils.equalsIgnoreCase((CharSequence)container.toString(), (CharSequence)runtime.getWebContainer().getValue())).findFirst().orElse(null);
    }

    static JavaVersion toWindowsJavaVersion(Runtime runtime) {
        return JavaVersion.values().stream().filter(serviceVersion -> StringUtils.equalsIgnoreCase((CharSequence)serviceVersion.toString(), (CharSequence)runtime.getJavaVersion().getValue())).findFirst().orElse(null);
    }

    static PublishingProfile fromPublishingProfile(com.azure.resourcemanager.appservice.models.PublishingProfile publishingProfile) {
        return ((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)PublishingProfile.builder().ftpUrl(publishingProfile.ftpUrl())).ftpUsername(publishingProfile.ftpUsername())).ftpPassword(publishingProfile.ftpPassword())).gitUrl(publishingProfile.gitUrl())).gitUsername(publishingProfile.gitUsername())).gitPassword(publishingProfile.gitPassword())).build();
    }

    static com.azure.resourcemanager.appservice.models.PricingTier toPricingTier(PricingTier pricingTier) {
        SkuDescription skuDescription = new SkuDescription().withTier(pricingTier.getTier()).withSize(pricingTier.getSize());
        return com.azure.resourcemanager.appservice.models.PricingTier.fromSkuDescription((SkuDescription)skuDescription);
    }

    static PricingTier fromPricingTier(com.azure.resourcemanager.appservice.models.PricingTier pricingTier) {
        return PricingTier.values().stream().filter(value -> StringUtils.equals((CharSequence)value.getSize(), (CharSequence)pricingTier.toSkuDescription().size()) && StringUtils.equals((CharSequence)value.getTier(), (CharSequence)pricingTier.toSkuDescription().tier())).findFirst().orElse(null);
    }

    static com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem fromOperatingSystem(OperatingSystem operatingSystem) {
        return Arrays.stream(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.values()).filter(os -> StringUtils.equals((CharSequence)operatingSystem.name(), (CharSequence)os.getValue())).findFirst().orElse(null);
    }

    static com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion fromJavaVersion(JavaVersion javaVersion) {
        return com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.values().stream().filter(value -> StringUtils.equals((CharSequence)value.getValue(), (CharSequence)javaVersion.toString())).findFirst().orElse(null);
    }

    static JavaVersion toJavaVersion(com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion) {
        return JavaVersion.values().stream().filter(value -> StringUtils.equals((CharSequence)value.toString(), (CharSequence)javaVersion.getValue())).findFirst().orElse(null);
    }

    static FunctionAppEntity fromFunctionApp(FunctionApp functionApp) {
        return ((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)FunctionAppEntity.builder().name(functionApp.name())).id(functionApp.id())).region(Region.fromName((String)functionApp.regionName()))).resourceGroup(functionApp.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(functionApp.id()))).runtime(AppServiceUtils.getRuntimeFromAppService((WebAppBase)functionApp))).appServicePlanId(functionApp.appServicePlanId())).defaultHostName(functionApp.defaultHostname())).appSettings(Utils.normalizeAppSettings(functionApp.getAppSettings()))).build();
    }

    static FunctionAppEntity fromFunctionAppBasic(FunctionAppBasic functionApp) {
        return ((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)FunctionAppEntity.builder().name(functionApp.name())).id(functionApp.id())).region(Region.fromName((String)functionApp.regionName()))).resourceGroup(functionApp.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(functionApp.id()))).runtime(null)).appServicePlanId(functionApp.appServicePlanId())).defaultHostName(functionApp.defaultHostname())).build();
    }

    static WebAppEntity fromWebApp(WebAppBase webAppBase) {
        return ((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().name(webAppBase.name())).id(webAppBase.id())).region(Region.fromName((String)webAppBase.regionName()))).resourceGroup(webAppBase.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(webAppBase.id()))).runtime(AppServiceUtils.getRuntimeFromAppService(webAppBase))).appServicePlanId(webAppBase.appServicePlanId())).defaultHostName(webAppBase.defaultHostname())).appSettings(Utils.normalizeAppSettings(webAppBase.getAppSettings()))).build();
    }

    static WebAppEntity fromWebAppBasic(WebAppBasic webAppBasic) {
        return ((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().name(webAppBasic.name())).id(webAppBasic.id())).region(Region.fromName((String)webAppBasic.regionName()))).resourceGroup(webAppBasic.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(webAppBasic.id()))).appServicePlanId(webAppBasic.appServicePlanId())).defaultHostName(webAppBasic.defaultHostname())).build();
    }

    static FunctionAppDeploymentSlotEntity fromFunctionAppDeploymentSlot(FunctionDeploymentSlot deploymentSlot) {
        return ((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)((AppServiceBaseEntity.AppServiceBaseEntityBuilder)((FunctionAppDeploymentSlotEntity.FunctionAppDeploymentSlotEntityBuilder)FunctionAppDeploymentSlotEntity.builder().name(deploymentSlot.name())).functionAppName(((FunctionApp)deploymentSlot.parent()).name())).id(deploymentSlot.id())).resourceGroup(deploymentSlot.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(deploymentSlot.id()))).runtime(AppServiceUtils.getRuntimeFromAppService((WebAppBase)deploymentSlot))).appServicePlanId(deploymentSlot.appServicePlanId())).defaultHostName(deploymentSlot.defaultHostname())).appSettings(Utils.normalizeAppSettings(deploymentSlot.getAppSettings()))).build();
    }

    static WebAppDeploymentSlotEntity fromWebAppDeploymentSlot(DeploymentSlot deploymentSlot) {
        return ((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((AppServiceBaseEntity.AppServiceBaseEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().name(deploymentSlot.name())).webappName(((WebApp)deploymentSlot.parent()).name())).id(deploymentSlot.id())).resourceGroup(deploymentSlot.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(deploymentSlot.id()))).runtime(AppServiceUtils.getRuntimeFromAppService((WebAppBase)deploymentSlot))).appServicePlanId(deploymentSlot.appServicePlanId())).defaultHostName(deploymentSlot.defaultHostname())).appSettings(Utils.normalizeAppSettings(deploymentSlot.getAppSettings()))).build();
    }

    static AppServicePlanEntity fromAppServicePlan(AppServicePlan appServicePlan) {
        return ((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().id(appServicePlan.id())).subscriptionId(Utils.getSubscriptionId(appServicePlan.id()))).name(appServicePlan.name())).region(appServicePlan.regionName())).resourceGroup(appServicePlan.resourceGroupName())).pricingTier(AppServiceUtils.fromPricingTier(appServicePlan.pricingTier()))).operatingSystem(AppServiceUtils.fromOperatingSystem(appServicePlan.operatingSystem()))).build();
    }

    static AppServicePlan getAppServicePlan(AppServicePlanEntity entity, AzureResourceManager azureClient) {
        try {
            return StringUtils.isNotEmpty((CharSequence)entity.getId()) ? (AppServicePlan)azureClient.appServicePlans().getById(entity.getId()) : (AppServicePlan)azureClient.appServicePlans().getByResourceGroup(entity.getResourceGroup(), entity.getName());
        }
        catch (ManagementException e) {
            return null;
        }
    }

    static DiagnosticConfig fromWebAppDiagnosticLogs(WebAppDiagnosticLogs webAppDiagnosticLogs) {
        DiagnosticConfig.DiagnosticConfigBuilder<?, ?> builder = DiagnosticConfig.builder();
        com.azure.resourcemanager.appservice.models.LogLevel applicationLogLevel = Optional.ofNullable(webAppDiagnosticLogs).map(HasInnerModel::innerModel).map(SiteLogsConfigInner::applicationLogs).map(ApplicationLogsConfig::fileSystem).map(FileSystemApplicationLogsConfig::level).orElse(null);
        if (applicationLogLevel != null && applicationLogLevel != com.azure.resourcemanager.appservice.models.LogLevel.OFF) {
            ((DiagnosticConfig.DiagnosticConfigBuilder)builder.enableApplicationLog(true)).applicationLogLevel(LogLevel.fromString(applicationLogLevel.toString()));
        } else {
            builder.enableApplicationLog(false);
        }
        FileSystemHttpLogsConfig httpLogsConfig = Optional.ofNullable(webAppDiagnosticLogs).map(HasInnerModel::innerModel).map(SiteLogsConfigInner::httpLogs).map(HttpLogsConfig::fileSystem).orElse(null);
        if (httpLogsConfig != null && httpLogsConfig.enabled().booleanValue()) {
            ((DiagnosticConfig.DiagnosticConfigBuilder)((DiagnosticConfig.DiagnosticConfigBuilder)((DiagnosticConfig.DiagnosticConfigBuilder)((DiagnosticConfig.DiagnosticConfigBuilder)builder.enableWebServerLogging(true)).webServerLogQuota(httpLogsConfig.retentionInMb())).webServerRetentionPeriod(httpLogsConfig.retentionInDays())).enableDetailedErrorMessage(webAppDiagnosticLogs.detailedErrorMessages())).enableFailedRequestTracing(webAppDiagnosticLogs.failedRequestsTracing());
        } else {
            builder.enableWebServerLogging(false);
        }
        return builder.build();
    }

    static void defineDiagnosticConfigurationForWebAppBase(WebAppBase.DefinitionStages.WithCreate withCreate, DiagnosticConfig diagnosticConfig) {
        if (diagnosticConfig.isEnableApplicationLog()) {
            withCreate.defineDiagnosticLogsConfiguration().withApplicationLogging().withLogLevel(com.azure.resourcemanager.appservice.models.LogLevel.fromString((String)diagnosticConfig.getApplicationLogLevel().getValue())).withApplicationLogsStoredOnFileSystem().attach();
        }
        if (diagnosticConfig.isEnableWebServerLogging()) {
            withCreate.defineDiagnosticLogsConfiguration().withWebServerLogging().withWebServerLogsStoredOnFileSystem().withWebServerFileSystemQuotaInMB(diagnosticConfig.getWebServerLogQuota().intValue()).withLogRetentionDays(diagnosticConfig.getWebServerRetentionPeriod().intValue()).withDetailedErrorMessages(diagnosticConfig.isEnableDetailedErrorMessage()).withFailedRequestTracing(diagnosticConfig.isEnableFailedRequestTracing()).attach();
        }
    }

    static void updateDiagnosticConfigurationForWebAppBase(WebAppBase.Update update, DiagnosticConfig diagnosticConfig) {
        WebAppDiagnosticLogs.UpdateStages.Blank blank = update.updateDiagnosticLogsConfiguration();
        if (diagnosticConfig.isEnableApplicationLog()) {
            blank.withApplicationLogging().withLogLevel(com.azure.resourcemanager.appservice.models.LogLevel.fromString((String)diagnosticConfig.getApplicationLogLevel().getValue())).withApplicationLogsStoredOnFileSystem().parent();
        } else {
            blank.withoutApplicationLogging().parent();
        }
        if (diagnosticConfig.isEnableWebServerLogging()) {
            blank.withWebServerLogging().withWebServerLogsStoredOnFileSystem().withWebServerFileSystemQuotaInMB(diagnosticConfig.getWebServerLogQuota().intValue()).withLogRetentionDays(diagnosticConfig.getWebServerRetentionPeriod().intValue()).withDetailedErrorMessages(diagnosticConfig.isEnableDetailedErrorMessage()).withFailedRequestTracing(diagnosticConfig.isEnableFailedRequestTracing()).parent();
        } else {
            blank.withoutWebServerLogging().parent();
        }
    }

    public static FunctionEntity fromFunctionAppEnvelope(FunctionEnvelope functionEnvelope) {
        Object config = functionEnvelope.config();
        if (!(config instanceof Map)) {
            return null;
        }
        Map envelopeConfigMap = (Map)config;
        String scriptFile = (String)envelopeConfigMap.get(SCRIPT_FILE);
        String entryPoint = (String)envelopeConfigMap.get(ENTRY_POINT);
        Object bindingListObject = ((Map)config).get(BINDINGS);
        List<FunctionEntity.BindingEntity> bindingEntities = Optional.ofNullable(bindingListObject instanceof List ? (List)bindingListObject : null).map(list -> list.stream().filter(item -> item instanceof Map).map(map -> AppServiceUtils.fromJsonBinding((Map)map)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return ((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)FunctionEntity.builder().name(((FunctionEnvelopeInner)functionEnvelope.innerModel()).name())).entryPoint(entryPoint)).scriptFile(scriptFile)).bindingList(bindingEntities)).functionAppId(functionEnvelope.functionAppId())).triggerId(((FunctionEnvelopeInner)functionEnvelope.innerModel()).id())).triggerUrl(((FunctionEnvelopeInner)functionEnvelope.innerModel()).invokeUrlTemplate())).build();
    }

    private static FunctionEntity.BindingEntity fromJsonBinding(Map bindingProperties) {
        return ((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)FunctionEntity.BindingEntity.builder().type((String)bindingProperties.get("type"))).direction((String)bindingProperties.get("direction"))).name((String)bindingProperties.get("name"))).properties(bindingProperties)).build();
    }
}

