/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.manager.AppServiceKuduManager;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;

abstract class AbstractAppService<T extends WebAppBase, R extends AppServiceBaseEntity>
implements IAppService<R> {
    protected AppServiceKuduManager kuduManager;
    protected R entity;
    protected T remote;

    AbstractAppService() {
    }

    public AbstractAppService<T, R> refresh() {
        this.remote = this.remote();
        this.entity = Optional.ofNullable(this.remote).map(this::getEntityFromRemoteResource).orElseThrow(() -> new AzureToolkitRuntimeException("Target resource does not exist."));
        return this;
    }

    @Override
    public void start() {
        this.getRemoteResource().start();
    }

    @Override
    public void stop() {
        this.getRemoteResource().stop();
    }

    @Override
    public void restart() {
        this.getRemoteResource().restart();
    }

    public String name() {
        return this.entity().getName();
    }

    public String id() {
        return this.entity().getId();
    }

    @Nonnull
    public R entity() {
        if (this.remote == null) {
            this.refresh();
        }
        return this.entity;
    }

    @Override
    public boolean exists() {
        try {
            return this.remote() != null;
        }
        catch (ManagementException e) {
            return false;
        }
    }

    @Override
    public String hostName() {
        return this.getRemoteResource().defaultHostname();
    }

    @Override
    public String state() {
        return this.getRemoteResource().state();
    }

    @Override
    public Runtime getRuntime() {
        return this.entity().getRuntime();
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return AppServiceUtils.fromPublishingProfile(this.getRemoteResource().getPublishingProfile());
    }

    @Override
    public DiagnosticConfig getDiagnosticConfig() {
        return AppServiceUtils.fromWebAppDiagnosticLogs(this.getRemoteResource().diagnosticLogsConfig());
    }

    @Override
    public Flux<String> streamAllLogsAsync() {
        return this.getRemoteResource().streamAllLogsAsync();
    }

    @Override
    public Flux<ByteBuffer> getFileContent(String path) {
        return this.getKuduManager().getFileContent(path);
    }

    @Override
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return this.getKuduManager().getFilesInDirectory(dir);
    }

    @Override
    public AppServiceFile getFileByPath(String path) {
        return this.getKuduManager().getFileByPath(path);
    }

    @Override
    public void uploadFileToPath(String content, String path) {
        this.getKuduManager().uploadFileToPath(content, path);
    }

    @Override
    public void createDirectory(String path) {
        this.getKuduManager().createDirectory(path);
    }

    @Override
    public void deleteFile(String path) {
        this.getKuduManager().deleteFile(path);
    }

    @Override
    public List<ProcessInfo> listProcess() {
        return this.getKuduManager().listProcess();
    }

    @Override
    public CommandOutput execute(String command, String dir) {
        return this.getKuduManager().execute(command, dir);
    }

    @Override
    public TunnelStatus getAppServiceTunnelStatus() {
        return this.getKuduManager().getAppServiceTunnelStatus();
    }

    protected AppServiceKuduManager getKuduManager() {
        if (this.kuduManager == null) {
            this.kuduManager = AppServiceKuduManager.getClient(this.getRemoteResource(), this);
        }
        return this.kuduManager;
    }

    @Nonnull
    protected T getRemoteResource() {
        if (this.remote == null) {
            this.refresh();
        }
        return (T)((WebAppBase)Objects.requireNonNull(this.remote, "Target resource does not exist."));
    }

    @Nonnull
    protected abstract R getEntityFromRemoteResource(@Nonnull T var1);

    @Nullable
    protected abstract T remote();
}

