/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DeployType {
    public static final DeployType WAR = new DeployType("war");
    public static final DeployType JAR = new DeployType("jar");
    public static final DeployType EAR = new DeployType("ear");
    public static final DeployType JAR_LIB = new DeployType("lib");
    public static final DeployType STATIC = new DeployType("static");
    public static final DeployType SCRIPT_STARTUP = new DeployType("startup");
    public static final DeployType ZIP = new DeployType("zip");
    private static final Map<DeployType, String> TYPE_TO_TARGET_DIRECTORY_MAP = new HashMap<DeployType, String>();
    private static final Map<DeployType, String> DEPLOY_TYPE_TO_FILE_EXTENSION_MAP = new HashMap<DeployType, String>();
    private static final String WWWROOT = "/home/site/wwwroot/";
    private final String value;

    public static List<DeployType> values() {
        return Arrays.asList(WAR, JAR, EAR, JAR_LIB, STATIC, SCRIPT_STARTUP, ZIP);
    }

    public static DeployType fromString(String input) {
        return DeployType.values().stream().filter(deployType -> StringUtils.equalsIgnoreCase((CharSequence)deployType.getValue(), (CharSequence)input)).findFirst().orElse(null);
    }

    public String getFileExt() {
        return DEPLOY_TYPE_TO_FILE_EXTENSION_MAP.get(this);
    }

    public boolean requireSingleFile() {
        return Arrays.asList(WAR, JAR, EAR, SCRIPT_STARTUP, ZIP).contains(this);
    }

    public boolean requirePath() {
        return Arrays.asList(JAR_LIB, STATIC).contains(this);
    }

    public boolean ignorePath() {
        return Arrays.asList(JAR, EAR, SCRIPT_STARTUP).contains(this);
    }

    public String getTargetPathPrefix() {
        return TYPE_TO_TARGET_DIRECTORY_MAP.get(this);
    }

    public String toString() {
        return this.value;
    }

    public static DeployType getDeployTypeFromFile(File file) {
        DeployType type = DeployType.fromString(FilenameUtils.getExtension((String)file.getName()));
        if (type == null) {
            return ZIP;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type.getFileExt(), (CharSequence)FilenameUtils.getExtension((String)file.getName()))) {
            return type;
        }
        return ZIP;
    }

    public String getValue() {
        return this.value;
    }

    public DeployType(String value) {
        this.value = value;
    }

    static {
        TYPE_TO_TARGET_DIRECTORY_MAP.put(JAR, WWWROOT);
        TYPE_TO_TARGET_DIRECTORY_MAP.put(EAR, WWWROOT);
        TYPE_TO_TARGET_DIRECTORY_MAP.put(STATIC, WWWROOT);
        TYPE_TO_TARGET_DIRECTORY_MAP.put(ZIP, WWWROOT);
        TYPE_TO_TARGET_DIRECTORY_MAP.put(WAR, "/home/site/wwwroot//webapps/");
        TYPE_TO_TARGET_DIRECTORY_MAP.put(SCRIPT_STARTUP, "/home/site/scripts/");
        TYPE_TO_TARGET_DIRECTORY_MAP.put(JAR_LIB, "/home/site/libs/");
        DEPLOY_TYPE_TO_FILE_EXTENSION_MAP.put(JAR, "jar");
        DEPLOY_TYPE_TO_FILE_EXTENSION_MAP.put(EAR, "ear");
        DEPLOY_TYPE_TO_FILE_EXTENSION_MAP.put(WAR, "war");
        DEPLOY_TYPE_TO_FILE_EXTENSION_MAP.put(JAR_LIB, "jar");
        DEPLOY_TYPE_TO_FILE_EXTENSION_MAP.put(ZIP, "zip");
    }
}

