/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.file;

import com.google.common.base.Joiner;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.toolkit.lib.appservice.file.AppServiceFileClient;
import com.microsoft.azure.toolkit.lib.appservice.file.KuduFileClient;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFileLegacy;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.rest.RestClient;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSource;
import org.apache.commons.codec.binary.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import rx.Emitter;
import rx.Observable;

@Deprecated
public class AppServiceFileService {
    private final AppServiceFileClient client;
    private final WebAppBase app;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    private AppServiceFileService(WebAppBase app, AppServiceFileClient client) {
        this.app = app;
        this.client = client;
    }

    @Nullable
    @AzureOperation(name="appservice|file.get.path", params={"path", "this.app.name()"}, type=AzureOperation.Type.SERVICE)
    public AppServiceFileLegacy getFileByPath(String path) {
        String string = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            File file = new File(path);
            List<? extends AppServiceFileLegacy> result = this.getFilesInDirectory(file.getParent());
            AppServiceFileLegacy appServiceFileLegacy = result.stream().filter(appServiceFile -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)appServiceFile.getName())).findFirst().orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServiceFileLegacy;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="appservice|file.list.dir", params={"dir", "this.app.name()"}, type=AzureOperation.Type.SERVICE)
    public List<? extends AppServiceFileLegacy> getFilesInDirectory(String dir) {
        String string = dir;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Predicate<AppServiceFileLegacy> filter = file -> !"text/xml".equals(file.getMime()) || !file.getName().contains("LogFiles-kudu-trace_pending.xml");
            List<AppServiceFileLegacy> files = ((List)this.client.getFilesInDirectory(dir).toBlocking().first()).stream().filter(filter).collect(Collectors.toList());
            files.forEach(file -> {
                file.setApp(this.app);
                file.setPath(dir + "/" + file.getName());
            });
            List<AppServiceFileLegacy> list = files;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="appservice|file.get_content", params={"path", "this.app.name()"}, type=AzureOperation.Type.SERVICE)
    public Observable<byte[]> getFileContent(String path) {
        String string = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Observable observable = this.client.getFileContent(path).flatMap(responseBody -> {
                BufferedSource source = responseBody.source();
                return Observable.create(emitter -> {
                    try {
                        while (!source.exhausted()) {
                            emitter.onNext((Object)source.readByteArray());
                        }
                        emitter.onCompleted();
                    }
                    catch (IOException e) {
                        emitter.onError((Throwable)e);
                    }
                }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER);
            });
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return observable;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="appservice|file.upload", params={"path", "this.app.name()"}, type=AzureOperation.Type.SERVICE)
    public void uploadFileToPath(String content, String path) {
        String string = content;
        String string2 = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (String)content);
            this.client.saveFile(path, body).toBlocking().single();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public static AppServiceFileService forApp(WebAppBase app) {
        AppServiceFileClient client = AppServiceFileService.getClient(app);
        return new AppServiceFileService(app, client);
    }

    private static AppServiceFileClient getClient(WebAppBase app) {
        if (app.defaultHostName() == null) {
            throw new UnsupportedOperationException("Cannot initialize kudu vfs client before web app is created");
        }
        String host = app.defaultHostName().toLowerCase().replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = Joiner.on((char)'.').join((Object)parts[0], (Object)"scm", new Object[]{parts[1]});
        AppServiceManager manager = (AppServiceManager)app.manager();
        RestClient restClient = AppServiceFileService.getRestClient(manager);
        return (AppServiceFileClient)restClient.newBuilder().withBaseUrl("https://" + host).withConnectionTimeout(3L, TimeUnit.MINUTES).withReadTimeout(3L, TimeUnit.MINUTES).build().retrofit().create(KuduFileClient.class);
    }

    private static RestClient getRestClient(AppServiceManager manager) {
        Method method = manager.getClass().getDeclaredMethod("restClient", new Class[0]);
        method.setAccessible(true);
        return (RestClient)method.invoke((Object)manager, new Object[0]);
    }

    static {
        AppServiceFileService.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppServiceFileService.java", AppServiceFileService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFileByPath", "com.microsoft.azure.toolkit.lib.appservice.file.AppServiceFileService", "java.lang.String", "path", "", "com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFileLegacy"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFilesInDirectory", "com.microsoft.azure.toolkit.lib.appservice.file.AppServiceFileService", "java.lang.String", "dir", "", "java.util.List"), 67);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFileContent", "com.microsoft.azure.toolkit.lib.appservice.file.AppServiceFileService", "java.lang.String", "path", "", "rx.Observable"), 82);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileToPath", "com.microsoft.azure.toolkit.lib.appservice.file.AppServiceFileService", "java.lang.String:java.lang.String", "content:path", "", "void"), 104);
    }
}

