/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.template;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionSettingTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.TemplateMetadata;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FunctionTemplate {
    public static final String VALUE = "<value>";
    private String id;
    private TemplateMetadata metadata;
    private List<String> bundle;
    private Function function;
    private Map<String, String> files;
    @JsonIgnore
    private BindingTemplate binding;

    public Set<FunctionExtensionVersion> getSupportedExtensionVersions() {
        return CollectionUtils.isEmpty(this.bundle) ? null : this.bundle.stream().map(FunctionUtils::parseFunctionExtensionVersion).collect(Collectors.toSet());
    }

    public boolean isBundleSupported(FunctionExtensionVersion version) {
        return CollectionUtils.isEmpty(this.bundle) || this.bundle.contains(version.getVersion());
    }

    @Nullable
    public BindingConfiguration getBindingConfiguration() {
        return this.isTriggerTemplate() ? this.getTrigger() : (BindingConfiguration)Optional.ofNullable(this.function).map(Function::getBindings).filter(CollectionUtils::isNotEmpty).map(bindings -> (BindingConfiguration)bindings.get(0)).orElse(null);
    }

    public boolean isTriggerTemplate() {
        return Objects.nonNull(this.getTrigger());
    }

    @Nullable
    public BindingConfiguration getTrigger() {
        List bindings = Optional.ofNullable(this.function).map(Function::getBindings).orElse(Collections.emptyList());
        return bindings.stream().filter(BindingConfiguration::isTrigger).findFirst().orElse(null);
    }

    @Nullable
    @Deprecated
    public String getTriggerType() {
        return Optional.ofNullable(this.getBindingConfiguration()).map(BindingConfiguration::getType).orElse(null);
    }

    @Nonnull
    public String generateContent(Map<String, String> parameters) {
        String templateContent = Objects.requireNonNull(this.getFiles().get("function.java"), String.format("failed to load template of binding %s", this.getFunction()));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            templateContent = templateContent.replace(String.format("$%s$", entry.getKey()), entry.getValue());
        }
        return templateContent;
    }

    @Nonnull
    public String generateDefaultContent(@Nonnull String packageName, @Nonnull String className) {
        List<String> prompts = Optional.ofNullable(this.getMetadata().getUserPrompt()).orElse(Collections.emptyList());
        FunctionSettingTemplate[] settings = Optional.ofNullable(this.getBinding()).map(BindingTemplate::getSettings).orElse(null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("packageName", packageName);
        parameters.put("className", className);
        parameters.put("functionName", className);
        prompts.forEach(parameter -> {
            FunctionSettingTemplate settingTemplate = settings == null ? null : (FunctionSettingTemplate)Arrays.stream(settings).filter(template -> StringUtils.equals((CharSequence)template.getName(), (CharSequence)parameter)).findFirst().orElse(null);
            parameters.put((String)parameter, Optional.ofNullable(settingTemplate).map(this::getParameterDefaultValue).orElse(VALUE));
        });
        return this.generateContent(parameters);
    }

    private String getParameterDefaultValue(@Nonnull FunctionSettingTemplate template) {
        if (StringUtils.isNotEmpty((CharSequence)template.getDefaultValue())) {
            return template.getDefaultValue();
        }
        switch (template.getValue()) {
            case "boolean": {
                return Boolean.FALSE.toString();
            }
            case "enum": {
                return Optional.ofNullable(template.getSettingEnum()).filter(ArrayUtils::isNotEmpty).map(array -> array[0].getValue()).orElse(VALUE);
            }
        }
        return VALUE;
    }

    @Nullable
    public String getName() {
        return Optional.ofNullable(this.getMetadata()).map(TemplateMetadata::getName).orElse(null);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public TemplateMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<String> getBundle() {
        return this.bundle;
    }

    @Generated
    public Function getFunction() {
        return this.function;
    }

    @Generated
    public Map<String, String> getFiles() {
        return this.files;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(TemplateMetadata metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setBundle(List<String> bundle) {
        this.bundle = bundle;
    }

    @Generated
    public void setFunction(Function function) {
        this.function = function;
    }

    @Generated
    public void setFiles(Map<String, String> files) {
        this.files = files;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionTemplate)) {
            return false;
        }
        FunctionTemplate other = (FunctionTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TemplateMetadata this$metadata = this.getMetadata();
        TemplateMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<String> this$bundle = this.getBundle();
        List<String> other$bundle = other.getBundle();
        if (this$bundle == null ? other$bundle != null : !((Object)this$bundle).equals(other$bundle)) {
            return false;
        }
        Function this$function = this.getFunction();
        Function other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        Map<String, String> this$files = this.getFiles();
        Map<String, String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        BindingTemplate this$binding = this.getBinding();
        BindingTemplate other$binding = other.getBinding();
        return !(this$binding == null ? other$binding != null : !((Object)this$binding).equals(other$binding));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TemplateMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<String> $bundle = this.getBundle();
        result = result * 59 + ($bundle == null ? 43 : ((Object)$bundle).hashCode());
        Function $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        Map<String, String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        BindingTemplate $binding = this.getBinding();
        result = result * 59 + ($binding == null ? 43 : ((Object)$binding).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FunctionTemplate(id=" + this.getId() + ", metadata=" + this.getMetadata() + ", bundle=" + this.getBundle() + ", function=" + this.getFunction() + ", files=" + this.getFiles() + ", binding=" + this.getBinding() + ")";
    }

    @Generated
    public FunctionTemplate() {
    }

    @Generated
    public BindingTemplate getBinding() {
        return this.binding;
    }

    @JsonIgnore
    @Generated
    public void setBinding(BindingTemplate binding) {
        this.binding = binding;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Function {
        private boolean disabled;
        private List<BindingConfiguration> bindings;

        @Generated
        public boolean isDisabled() {
            return this.disabled;
        }

        @Generated
        public List<BindingConfiguration> getBindings() {
            return this.bindings;
        }

        @Generated
        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        @Generated
        public void setBindings(List<BindingConfiguration> bindings) {
            this.bindings = bindings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Function)) {
                return false;
            }
            Function other = (Function)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDisabled() != other.isDisabled()) {
                return false;
            }
            List<BindingConfiguration> this$bindings = this.getBindings();
            List<BindingConfiguration> other$bindings = other.getBindings();
            return !(this$bindings == null ? other$bindings != null : !((Object)this$bindings).equals(other$bindings));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Function;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDisabled() ? 79 : 97);
            List<BindingConfiguration> $bindings = this.getBindings();
            result = result * 59 + ($bindings == null ? 43 : ((Object)$bindings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionTemplate.Function(disabled=" + this.isDisabled() + ", bindings=" + this.getBindings() + ")";
        }

        @Generated
        public Function() {
        }
    }
}

