/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.handlers;

import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.CommandUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandlerImpl
implements CommandHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandHandlerImpl.class);

    @Override
    public void runCommandWithReturnCodeCheck(String command, boolean showStdout, String workingDirectory, List<Long> validReturnCodes, String errorMessage) throws AzureExecutionException {
        try {
            Process process = this.runCommand(command, showStdout, workingDirectory);
            this.handleExitValue(process.exitValue(), validReturnCodes, errorMessage, process.getInputStream());
        }
        catch (IOException | InterruptedException ex) {
            throw new AzureExecutionException("Cannot execute '" + command + "'", (Throwable)ex);
        }
    }

    @Override
    public String runCommandAndGetOutput(String command, boolean showStdout, String workingDirectory) throws AzureExecutionException {
        try {
            Process process = this.runCommand(command, showStdout, workingDirectory);
            return this.getOutputFromProcess(process);
        }
        catch (IOException | InterruptedException ex) {
            throw new AzureExecutionException("Cannot execute '" + command + "'", (Throwable)ex);
        }
    }

    protected String getOutputFromProcess(Process process) throws IOException {
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String s;
            StringBuilder stdout = new StringBuilder();
            while ((s = stdInput.readLine()) != null) {
                stdout.append(s);
            }
            String string = stdout.toString().trim();
            return string;
        }
    }

    protected Process runCommand(String command, boolean showStdout, String workingDirectory) throws IOException, InterruptedException {
        log.debug("Executing command: " + StringUtils.join((Object[])new String[]{command, " "}));
        ProcessBuilder.Redirect redirect = CommandHandlerImpl.getStdoutRedirect(showStdout);
        ProcessBuilder processBuilder = new ProcessBuilder(CommandHandlerImpl.buildCommand(command)).redirectOutput(redirect).redirectErrorStream(true);
        if (workingDirectory != null) {
            processBuilder.directory(new File(workingDirectory));
        }
        Process process = processBuilder.start();
        process.waitFor();
        return process;
    }

    protected static String[] buildCommand(String command) {
        String[] stringArray;
        if (CommandUtils.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd.exe";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = command;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "sh";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = command;
        }
        return stringArray;
    }

    protected static ProcessBuilder.Redirect getStdoutRedirect(boolean showStdout) {
        return showStdout ? ProcessBuilder.Redirect.INHERIT : ProcessBuilder.Redirect.PIPE;
    }

    protected void handleExitValue(int exitValue, List<Long> validReturnCodes, String errorMessage, InputStream inputStream) throws AzureExecutionException, IOException {
        log.debug("Process exit value: " + exitValue);
        if (!validReturnCodes.contains(Integer.toUnsignedLong(exitValue))) {
            this.showErrorIfAny(inputStream);
            AzureMessager.getMessager().error(errorMessage);
            throw new AzureExecutionException(errorMessage);
        }
    }

    protected void showErrorIfAny(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            String input = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            AzureMessager.getMessager().error(StringUtils.strip((String)input, (String)"\n"));
        }
    }
}

