/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.DeploymentSlotConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AppServiceConfigUtils {
    public static FunctionAppConfig fromFunctionApp(@Nonnull FunctionAppBase<?, ?, ?> app) {
        return app instanceof FunctionApp && StringUtils.isNotBlank((CharSequence)((FunctionApp)app).getEnvironmentId()) ? AppServiceConfigUtils.fromFunctionApp((FunctionApp)app, ((FunctionApp)app).getEnvironment()) : AppServiceConfigUtils.fromFunctionApp(app, app.getAppServicePlan());
    }

    public static FunctionAppConfig fromFunctionApp(@Nonnull FunctionAppBase<?, ?, ?> app, @Nullable AppServicePlan servicePlan) {
        FunctionAppConfig result = new FunctionAppConfig();
        AppServiceConfigUtils.fromAppService(app, servicePlan, result);
        if (app instanceof FunctionApp) {
            FlexConsumptionConfiguration flexConsumptionConfiguration = app.getFlexConsumptionConfiguration();
            Optional.ofNullable(flexConsumptionConfiguration).ifPresent(result::flexConsumptionConfiguration);
        }
        return result;
    }

    public static FunctionAppConfig fromFunctionApp(@Nonnull FunctionApp app, @Nonnull ContainerAppsEnvironment environment) {
        FunctionAppConfig result = new FunctionAppConfig();
        AppServiceConfigUtils.fromAppService(app, null, result);
        result.environment(environment.getName());
        result.containerConfiguration(app.getContainerConfiguration());
        return result;
    }

    public static AppServiceConfig fromAppService(@Nonnull AppServiceAppBase<?, ?, ?> app) {
        return app instanceof FunctionAppBase ? AppServiceConfigUtils.fromFunctionApp((FunctionAppBase)app) : AppServiceConfigUtils.fromAppService(app, app.getAppServicePlan(), new AppServiceConfig());
    }

    public static AppServiceConfig fromAppService(@Nonnull AppServiceAppBase<?, ?, ?> app, @Nonnull AppServicePlan servicePlan) {
        return AppServiceConfigUtils.fromAppService(app, servicePlan, new AppServiceConfig());
    }

    public static AppServiceConfig fromAppService(@Nonnull AppServiceAppBase<?, ?, ?> base, @Nullable AppServicePlan servicePlan, @Nonnull AppServiceConfig config) {
        RuntimeConfig runtimeConfig;
        AppServiceAppBase app = base instanceof WebAppDeploymentSlot ? (AppServiceAppBase)((WebAppDeploymentSlot)base).getParent() : (base instanceof FunctionAppDeploymentSlot ? (AppServiceAppBase)((FunctionAppDeploymentSlot)base).getParent() : base);
        config.appName(app.getName());
        config.resourceGroup(app.getResourceGroupName());
        config.subscriptionId(app.getSubscriptionId());
        config.region(app.getRegion());
        Runtime runtime = app.getRuntime();
        if (runtime != null && runtime.isDocker()) {
            runtimeConfig = app.getDockerRuntimeConfig();
        } else {
            runtimeConfig = new RuntimeConfig();
            Optional.ofNullable(runtime).map(Runtime::getOperatingSystem).ifPresent(runtimeConfig::os);
            Optional.ofNullable(runtime).map(Runtime::getJavaVersionUserText).ifPresent(runtimeConfig::javaVersion);
            Optional.ofNullable(runtime).filter(r -> r instanceof WebAppRuntime).map(r -> (WebAppRuntime)r).map(WebAppRuntime::getContainerUserText).ifPresent(runtimeConfig::webContainer);
        }
        config.runtime(runtimeConfig);
        Optional.ofNullable(servicePlan).map(AppServicePlan::getPricingTier).ifPresent(config::pricingTier);
        Optional.ofNullable(servicePlan).map(AbstractAzResource::getName).ifPresent(config::servicePlanName);
        Optional.ofNullable(servicePlan).map(AbstractAzResource::getResourceGroupName).ifPresent(config::servicePlanResourceGroup);
        if (base instanceof FunctionAppDeploymentSlot || base instanceof WebAppDeploymentSlot) {
            config.setSlotConfig(DeploymentSlotConfig.builder().name(base.getName()).build());
        }
        return config;
    }

    public static AppServiceConfig buildDefaultWebAppConfig(String subscriptionId, String resourceGroup, String appName, String packaging) {
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultWebAppConfig(resourceGroup, appName, packaging);
        List<Region> regions = ((AppServiceServiceSubscription)((AzureAppService)Azure.az(AzureAppService.class)).forSubscription(subscriptionId)).listSupportedRegions();
        appServiceConfig.region((Region)Utils.selectFirstOptionIfCurrentInvalid((String)"region", regions, (Object)appServiceConfig.region()));
        return appServiceConfig;
    }

    public static void mergeAppServiceConfig(AppServiceConfig to, AppServiceConfig from) {
        try {
            Utils.copyProperties((Object)to, (Object)from, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("Cannot copy object for class AppServiceConfig.", (Throwable)e);
        }
        if (to.runtime() != from.runtime()) {
            AppServiceConfigUtils.mergeRuntime(to.runtime(), from.runtime());
        }
    }

    private static void mergeRuntime(RuntimeConfig to, RuntimeConfig from) {
        try {
            Utils.copyProperties((Object)to, (Object)from, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("Cannot copy object for class RuntimeConfig.", (Throwable)e);
        }
    }
}

