/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.StorageAuthenticationMethod;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class FunctionAppConfig {
    public static final FunctionAppConfig DEFAULT_CONFIG = FunctionAppConfig.builder().deployment(FunctionsDeployment.DEFAULT_DEPLOYMENT).runtime(FunctionsRuntime.DEFAULT_RUNTIME).scaleAndConcurrency(FunctionScaleAndConcurrency.DEFAULT_SCALE_CONFIGURATION).build();
    private FunctionsDeployment deployment;
    private FunctionsRuntime runtime;
    private FunctionScaleAndConcurrency scaleAndConcurrency;

    @Generated
    public static FunctionAppConfigBuilder builder() {
        return new FunctionAppConfigBuilder();
    }

    @Generated
    public FunctionsDeployment getDeployment() {
        return this.deployment;
    }

    @Generated
    public FunctionsRuntime getRuntime() {
        return this.runtime;
    }

    @Generated
    public FunctionScaleAndConcurrency getScaleAndConcurrency() {
        return this.scaleAndConcurrency;
    }

    @Generated
    public void setDeployment(FunctionsDeployment deployment) {
        this.deployment = deployment;
    }

    @Generated
    public void setRuntime(FunctionsRuntime runtime) {
        this.runtime = runtime;
    }

    @Generated
    public void setScaleAndConcurrency(FunctionScaleAndConcurrency scaleAndConcurrency) {
        this.scaleAndConcurrency = scaleAndConcurrency;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionAppConfig)) {
            return false;
        }
        FunctionAppConfig other = (FunctionAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionsDeployment this$deployment = this.getDeployment();
        FunctionsDeployment other$deployment = other.getDeployment();
        if (this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment)) {
            return false;
        }
        FunctionsRuntime this$runtime = this.getRuntime();
        FunctionsRuntime other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        FunctionScaleAndConcurrency this$scaleAndConcurrency = this.getScaleAndConcurrency();
        FunctionScaleAndConcurrency other$scaleAndConcurrency = other.getScaleAndConcurrency();
        return !(this$scaleAndConcurrency == null ? other$scaleAndConcurrency != null : !((Object)this$scaleAndConcurrency).equals(other$scaleAndConcurrency));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionAppConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionsDeployment $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        FunctionsRuntime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        FunctionScaleAndConcurrency $scaleAndConcurrency = this.getScaleAndConcurrency();
        result = result * 59 + ($scaleAndConcurrency == null ? 43 : ((Object)$scaleAndConcurrency).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FunctionAppConfig(deployment=" + this.getDeployment() + ", runtime=" + this.getRuntime() + ", scaleAndConcurrency=" + this.getScaleAndConcurrency() + ")";
    }

    @Generated
    public FunctionAppConfig() {
    }

    @Generated
    public FunctionAppConfig(FunctionsDeployment deployment, FunctionsRuntime runtime, FunctionScaleAndConcurrency scaleAndConcurrency) {
        this.deployment = deployment;
        this.runtime = runtime;
        this.scaleAndConcurrency = scaleAndConcurrency;
    }

    @Generated
    public static class FunctionAppConfigBuilder {
        @Generated
        private FunctionsDeployment deployment;
        @Generated
        private FunctionsRuntime runtime;
        @Generated
        private FunctionScaleAndConcurrency scaleAndConcurrency;

        @Generated
        FunctionAppConfigBuilder() {
        }

        @Generated
        public FunctionAppConfigBuilder deployment(FunctionsDeployment deployment) {
            this.deployment = deployment;
            return this;
        }

        @Generated
        public FunctionAppConfigBuilder runtime(FunctionsRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        @Generated
        public FunctionAppConfigBuilder scaleAndConcurrency(FunctionScaleAndConcurrency scaleAndConcurrency) {
            this.scaleAndConcurrency = scaleAndConcurrency;
            return this;
        }

        @Generated
        public FunctionAppConfig build() {
            return new FunctionAppConfig(this.deployment, this.runtime, this.scaleAndConcurrency);
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionAppConfigBuilder(deployment=" + this.deployment + ", runtime=" + this.runtime + ", scaleAndConcurrency=" + this.scaleAndConcurrency + ")";
        }
    }

    public static class FunctionsDeployment {
        public static final FunctionsDeployment DEFAULT_DEPLOYMENT = FunctionsDeployment.builder().storage(Storage.DEFAULT_STORAGE).build();
        private Storage storage;

        @Generated
        public static FunctionsDeploymentBuilder builder() {
            return new FunctionsDeploymentBuilder();
        }

        @Generated
        public Storage getStorage() {
            return this.storage;
        }

        @Generated
        public void setStorage(Storage storage) {
            this.storage = storage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionsDeployment)) {
                return false;
            }
            FunctionsDeployment other = (FunctionsDeployment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Storage this$storage = this.getStorage();
            Storage other$storage = other.getStorage();
            return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionsDeployment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Storage $storage = this.getStorage();
            result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionsDeployment(storage=" + this.getStorage() + ")";
        }

        @Generated
        public FunctionsDeployment() {
        }

        @Generated
        public FunctionsDeployment(Storage storage) {
            this.storage = storage;
        }

        @Generated
        public static class FunctionsDeploymentBuilder {
            @Generated
            private Storage storage;

            @Generated
            FunctionsDeploymentBuilder() {
            }

            @Generated
            public FunctionsDeploymentBuilder storage(Storage storage) {
                this.storage = storage;
                return this;
            }

            @Generated
            public FunctionsDeployment build() {
                return new FunctionsDeployment(this.storage);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.FunctionsDeployment.FunctionsDeploymentBuilder(storage=" + this.storage + ")";
            }
        }
    }

    public static class FunctionsRuntime {
        public static final FunctionsRuntime DEFAULT_RUNTIME = FunctionsRuntime.builder().name("java").version("17").build();
        private String name;
        private String version;

        @Generated
        private static String $default$name() {
            return "java";
        }

        @Generated
        public static FunctionsRuntimeBuilder builder() {
            return new FunctionsRuntimeBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionsRuntime)) {
                return false;
            }
            FunctionsRuntime other = (FunctionsRuntime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionsRuntime;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionsRuntime(name=" + this.getName() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public FunctionsRuntime() {
            this.name = FunctionsRuntime.$default$name();
        }

        @Generated
        public FunctionsRuntime(String name, String version) {
            this.name = name;
            this.version = version;
        }

        @Generated
        public static class FunctionsRuntimeBuilder {
            @Generated
            private boolean name$set;
            @Generated
            private String name$value;
            @Generated
            private String version;

            @Generated
            FunctionsRuntimeBuilder() {
            }

            @Generated
            public FunctionsRuntimeBuilder name(String name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public FunctionsRuntimeBuilder version(String version) {
                this.version = version;
                return this;
            }

            @Generated
            public FunctionsRuntime build() {
                String name$value = this.name$value;
                if (!this.name$set) {
                    name$value = FunctionsRuntime.$default$name();
                }
                return new FunctionsRuntime(name$value, this.version);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.FunctionsRuntime.FunctionsRuntimeBuilder(name$value=" + this.name$value + ", version=" + this.version + ")";
            }
        }
    }

    public static class FunctionScaleAndConcurrency {
        public static final int DEFAULT_INSTANCE_SIZE = 2048;
        public static final int DEFAULT_MAXIMUM_INSTANCE_COUNT = 100;
        public static final FunctionScaleAndConcurrency DEFAULT_SCALE_CONFIGURATION = FunctionScaleAndConcurrency.builder().instanceMemoryMB(2048).maximumInstanceCount(100).build();
        private FunctionAlwaysReadyConfig[] alwaysReady;
        private Integer maximumInstanceCount;
        private Integer instanceMemoryMB;
        private FunctionTriggers triggers;

        @Generated
        public static FunctionScaleAndConcurrencyBuilder builder() {
            return new FunctionScaleAndConcurrencyBuilder();
        }

        @Generated
        public FunctionAlwaysReadyConfig[] getAlwaysReady() {
            return this.alwaysReady;
        }

        @Generated
        public Integer getMaximumInstanceCount() {
            return this.maximumInstanceCount;
        }

        @Generated
        public Integer getInstanceMemoryMB() {
            return this.instanceMemoryMB;
        }

        @Generated
        public FunctionTriggers getTriggers() {
            return this.triggers;
        }

        @Generated
        public void setAlwaysReady(FunctionAlwaysReadyConfig[] alwaysReady) {
            this.alwaysReady = alwaysReady;
        }

        @Generated
        public void setMaximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
        }

        @Generated
        public void setInstanceMemoryMB(Integer instanceMemoryMB) {
            this.instanceMemoryMB = instanceMemoryMB;
        }

        @Generated
        public void setTriggers(FunctionTriggers triggers) {
            this.triggers = triggers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionScaleAndConcurrency)) {
                return false;
            }
            FunctionScaleAndConcurrency other = (FunctionScaleAndConcurrency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maximumInstanceCount = this.getMaximumInstanceCount();
            Integer other$maximumInstanceCount = other.getMaximumInstanceCount();
            if (this$maximumInstanceCount == null ? other$maximumInstanceCount != null : !((Object)this$maximumInstanceCount).equals(other$maximumInstanceCount)) {
                return false;
            }
            Integer this$instanceMemoryMB = this.getInstanceMemoryMB();
            Integer other$instanceMemoryMB = other.getInstanceMemoryMB();
            if (this$instanceMemoryMB == null ? other$instanceMemoryMB != null : !((Object)this$instanceMemoryMB).equals(other$instanceMemoryMB)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAlwaysReady(), other.getAlwaysReady())) {
                return false;
            }
            FunctionTriggers this$triggers = this.getTriggers();
            FunctionTriggers other$triggers = other.getTriggers();
            return !(this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionScaleAndConcurrency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maximumInstanceCount = this.getMaximumInstanceCount();
            result = result * 59 + ($maximumInstanceCount == null ? 43 : ((Object)$maximumInstanceCount).hashCode());
            Integer $instanceMemoryMB = this.getInstanceMemoryMB();
            result = result * 59 + ($instanceMemoryMB == null ? 43 : ((Object)$instanceMemoryMB).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAlwaysReady());
            FunctionTriggers $triggers = this.getTriggers();
            result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionScaleAndConcurrency(alwaysReady=" + Arrays.deepToString(this.getAlwaysReady()) + ", maximumInstanceCount=" + this.getMaximumInstanceCount() + ", instanceMemoryMB=" + this.getInstanceMemoryMB() + ", triggers=" + this.getTriggers() + ")";
        }

        @Generated
        public FunctionScaleAndConcurrency() {
        }

        @Generated
        public FunctionScaleAndConcurrency(FunctionAlwaysReadyConfig[] alwaysReady, Integer maximumInstanceCount, Integer instanceMemoryMB, FunctionTriggers triggers) {
            this.alwaysReady = alwaysReady;
            this.maximumInstanceCount = maximumInstanceCount;
            this.instanceMemoryMB = instanceMemoryMB;
            this.triggers = triggers;
        }

        @Generated
        public static class FunctionScaleAndConcurrencyBuilder {
            @Generated
            private FunctionAlwaysReadyConfig[] alwaysReady;
            @Generated
            private Integer maximumInstanceCount;
            @Generated
            private Integer instanceMemoryMB;
            @Generated
            private FunctionTriggers triggers;

            @Generated
            FunctionScaleAndConcurrencyBuilder() {
            }

            @Generated
            public FunctionScaleAndConcurrencyBuilder alwaysReady(FunctionAlwaysReadyConfig[] alwaysReady) {
                this.alwaysReady = alwaysReady;
                return this;
            }

            @Generated
            public FunctionScaleAndConcurrencyBuilder maximumInstanceCount(Integer maximumInstanceCount) {
                this.maximumInstanceCount = maximumInstanceCount;
                return this;
            }

            @Generated
            public FunctionScaleAndConcurrencyBuilder instanceMemoryMB(Integer instanceMemoryMB) {
                this.instanceMemoryMB = instanceMemoryMB;
                return this;
            }

            @Generated
            public FunctionScaleAndConcurrencyBuilder triggers(FunctionTriggers triggers) {
                this.triggers = triggers;
                return this;
            }

            @Generated
            public FunctionScaleAndConcurrency build() {
                return new FunctionScaleAndConcurrency(this.alwaysReady, this.maximumInstanceCount, this.instanceMemoryMB, this.triggers);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.FunctionScaleAndConcurrency.FunctionScaleAndConcurrencyBuilder(alwaysReady=" + Arrays.deepToString(this.alwaysReady) + ", maximumInstanceCount=" + this.maximumInstanceCount + ", instanceMemoryMB=" + this.instanceMemoryMB + ", triggers=" + this.triggers + ")";
            }
        }
    }

    public static class FunctionAlwaysReadyConfig {
        private String name;
        private Integer instanceCount;

        @Generated
        public static FunctionAlwaysReadyConfigBuilder builder() {
            return new FunctionAlwaysReadyConfigBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionAlwaysReadyConfig)) {
                return false;
            }
            FunctionAlwaysReadyConfig other = (FunctionAlwaysReadyConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$instanceCount = this.getInstanceCount();
            Integer other$instanceCount = other.getInstanceCount();
            if (this$instanceCount == null ? other$instanceCount != null : !((Object)this$instanceCount).equals(other$instanceCount)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionAlwaysReadyConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $instanceCount = this.getInstanceCount();
            result = result * 59 + ($instanceCount == null ? 43 : ((Object)$instanceCount).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionAlwaysReadyConfig(name=" + this.getName() + ", instanceCount=" + this.getInstanceCount() + ")";
        }

        @Generated
        public FunctionAlwaysReadyConfig() {
        }

        @Generated
        public FunctionAlwaysReadyConfig(String name, Integer instanceCount) {
            this.name = name;
            this.instanceCount = instanceCount;
        }

        @Generated
        public static class FunctionAlwaysReadyConfigBuilder {
            @Generated
            private String name;
            @Generated
            private Integer instanceCount;

            @Generated
            FunctionAlwaysReadyConfigBuilder() {
            }

            @Generated
            public FunctionAlwaysReadyConfigBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public FunctionAlwaysReadyConfigBuilder instanceCount(Integer instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            @Generated
            public FunctionAlwaysReadyConfig build() {
                return new FunctionAlwaysReadyConfig(this.name, this.instanceCount);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.FunctionAlwaysReadyConfig.FunctionAlwaysReadyConfigBuilder(name=" + this.name + ", instanceCount=" + this.instanceCount + ")";
            }
        }
    }

    public static class FunctionHttpTriggers {
        private Integer perInstanceConcurrency;

        @Generated
        public static FunctionHttpTriggersBuilder builder() {
            return new FunctionHttpTriggersBuilder();
        }

        @Generated
        public Integer getPerInstanceConcurrency() {
            return this.perInstanceConcurrency;
        }

        @Generated
        public void setPerInstanceConcurrency(Integer perInstanceConcurrency) {
            this.perInstanceConcurrency = perInstanceConcurrency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionHttpTriggers)) {
                return false;
            }
            FunctionHttpTriggers other = (FunctionHttpTriggers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$perInstanceConcurrency = this.getPerInstanceConcurrency();
            Integer other$perInstanceConcurrency = other.getPerInstanceConcurrency();
            return !(this$perInstanceConcurrency == null ? other$perInstanceConcurrency != null : !((Object)this$perInstanceConcurrency).equals(other$perInstanceConcurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionHttpTriggers;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $perInstanceConcurrency = this.getPerInstanceConcurrency();
            result = result * 59 + ($perInstanceConcurrency == null ? 43 : ((Object)$perInstanceConcurrency).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionHttpTriggers(perInstanceConcurrency=" + this.getPerInstanceConcurrency() + ")";
        }

        @Generated
        public FunctionHttpTriggers() {
        }

        @Generated
        public FunctionHttpTriggers(Integer perInstanceConcurrency) {
            this.perInstanceConcurrency = perInstanceConcurrency;
        }

        @Generated
        public static class FunctionHttpTriggersBuilder {
            @Generated
            private Integer perInstanceConcurrency;

            @Generated
            FunctionHttpTriggersBuilder() {
            }

            @Generated
            public FunctionHttpTriggersBuilder perInstanceConcurrency(Integer perInstanceConcurrency) {
                this.perInstanceConcurrency = perInstanceConcurrency;
                return this;
            }

            @Generated
            public FunctionHttpTriggers build() {
                return new FunctionHttpTriggers(this.perInstanceConcurrency);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.FunctionHttpTriggers.FunctionHttpTriggersBuilder(perInstanceConcurrency=" + this.perInstanceConcurrency + ")";
            }
        }
    }

    public static class FunctionTriggers {
        private FunctionHttpTriggers http;

        public FunctionTriggers(@Nonnull Integer httpInstanceConcurrency) {
            this.http = new FunctionHttpTriggers(httpInstanceConcurrency);
        }

        @Generated
        public static FunctionTriggersBuilder builder() {
            return new FunctionTriggersBuilder();
        }

        @Generated
        public FunctionHttpTriggers getHttp() {
            return this.http;
        }

        @Generated
        public void setHttp(FunctionHttpTriggers http) {
            this.http = http;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionTriggers)) {
                return false;
            }
            FunctionTriggers other = (FunctionTriggers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FunctionHttpTriggers this$http = this.getHttp();
            FunctionHttpTriggers other$http = other.getHttp();
            return !(this$http == null ? other$http != null : !((Object)this$http).equals(other$http));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionTriggers;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionHttpTriggers $http = this.getHttp();
            result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionTriggers(http=" + this.getHttp() + ")";
        }

        @Generated
        public FunctionTriggers() {
        }

        @Generated
        public FunctionTriggers(FunctionHttpTriggers http) {
            this.http = http;
        }

        @Generated
        public static class FunctionTriggersBuilder {
            @Generated
            private FunctionHttpTriggers http;

            @Generated
            FunctionTriggersBuilder() {
            }

            @Generated
            public FunctionTriggersBuilder http(FunctionHttpTriggers http) {
                this.http = http;
                return this;
            }

            @Generated
            public FunctionTriggers build() {
                return new FunctionTriggers(this.http);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.FunctionTriggers.FunctionTriggersBuilder(http=" + this.http + ")";
            }
        }
    }

    public static class Storage {
        public static final Storage DEFAULT_STORAGE = Storage.builder().authentication(Authentication.DEFAULT_AUTHENTICATION).build();
        private Type type;
        private String value;
        private Authentication authentication;

        @Generated
        private static Type $default$type() {
            return Type.blobContainer;
        }

        @Generated
        public static StorageBuilder builder() {
            return new StorageBuilder();
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Authentication getAuthentication() {
            return this.authentication;
        }

        @Generated
        public void setType(Type type) {
            this.type = type;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Storage)) {
                return false;
            }
            Storage other = (Storage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Authentication this$authentication = this.getAuthentication();
            Authentication other$authentication = other.getAuthentication();
            return !(this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Storage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Authentication $authentication = this.getAuthentication();
            result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionAppConfig.Storage(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ", authentication=" + this.getAuthentication() + ")";
        }

        @Generated
        public Storage() {
            this.type = Storage.$default$type();
        }

        @Generated
        public Storage(Type type, String value, Authentication authentication) {
            this.type = type;
            this.value = value;
            this.authentication = authentication;
        }

        public static enum Type {
            blobContainer;

        }

        @Generated
        public static class StorageBuilder {
            @Generated
            private boolean type$set;
            @Generated
            private Type type$value;
            @Generated
            private String value;
            @Generated
            private Authentication authentication;

            @Generated
            StorageBuilder() {
            }

            @Generated
            public StorageBuilder type(Type type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            @Generated
            public StorageBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public StorageBuilder authentication(Authentication authentication) {
                this.authentication = authentication;
                return this;
            }

            @Generated
            public Storage build() {
                Type type$value = this.type$value;
                if (!this.type$set) {
                    type$value = Storage.$default$type();
                }
                return new Storage(type$value, this.value, this.authentication);
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.Storage.StorageBuilder(type$value=" + (Object)((Object)this.type$value) + ", value=" + this.value + ", authentication=" + this.authentication + ")";
            }
        }

        public static class Authentication {
            public static final String DEPLOYMENT_STORAGE_CONNECTION_STRING = "DEPLOYMENT_STORAGE_CONNECTION_STRING";
            public static final Authentication DEFAULT_AUTHENTICATION = Authentication.builder().type(StorageAuthenticationMethod.StorageAccountConnectionString).storageAccountConnectionStringName("DEPLOYMENT_STORAGE_CONNECTION_STRING").build();
            private StorageAuthenticationMethod type;
            private String userAssignedIdentityResourceId;
            private String storageAccountConnectionStringName;

            @Nullable
            public static Authentication fromConfiguration(FlexConsumptionConfiguration configuration) {
                if (Objects.isNull((Object)configuration.getAuthenticationMethod())) {
                    return null;
                }
                switch (configuration.getAuthenticationMethod()) {
                    case StorageAccountConnectionString: {
                        return Authentication.builder().type(StorageAuthenticationMethod.StorageAccountConnectionString).userAssignedIdentityResourceId(null).storageAccountConnectionStringName(configuration.getStorageAccountConnectionString()).build();
                    }
                    case UserAssignedIdentity: {
                        return Authentication.builder().type(StorageAuthenticationMethod.UserAssignedIdentity).userAssignedIdentityResourceId(configuration.getUserAssignedIdentityResourceId()).storageAccountConnectionStringName(null).build();
                    }
                    case SystemAssignedIdentity: {
                        return Authentication.builder().type(StorageAuthenticationMethod.SystemAssignedIdentity).userAssignedIdentityResourceId(null).storageAccountConnectionStringName(null).build();
                    }
                }
                throw new AzureToolkitRuntimeException("Unsupported authentication method: " + (Object)((Object)configuration.getAuthenticationMethod()));
            }

            @Generated
            private static StorageAuthenticationMethod $default$type() {
                return StorageAuthenticationMethod.StorageAccountConnectionString;
            }

            @Generated
            private static String $default$storageAccountConnectionStringName() {
                return DEPLOYMENT_STORAGE_CONNECTION_STRING;
            }

            @Generated
            public static AuthenticationBuilder builder() {
                return new AuthenticationBuilder();
            }

            @Generated
            public StorageAuthenticationMethod getType() {
                return this.type;
            }

            @Generated
            public String getUserAssignedIdentityResourceId() {
                return this.userAssignedIdentityResourceId;
            }

            @Generated
            public String getStorageAccountConnectionStringName() {
                return this.storageAccountConnectionStringName;
            }

            @Generated
            public void setType(StorageAuthenticationMethod type) {
                this.type = type;
            }

            @Generated
            public void setUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
                this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
            }

            @Generated
            public void setStorageAccountConnectionStringName(String storageAccountConnectionStringName) {
                this.storageAccountConnectionStringName = storageAccountConnectionStringName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Authentication)) {
                    return false;
                }
                Authentication other = (Authentication)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StorageAuthenticationMethod this$type = this.getType();
                StorageAuthenticationMethod other$type = other.getType();
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$userAssignedIdentityResourceId = this.getUserAssignedIdentityResourceId();
                String other$userAssignedIdentityResourceId = other.getUserAssignedIdentityResourceId();
                if (this$userAssignedIdentityResourceId == null ? other$userAssignedIdentityResourceId != null : !this$userAssignedIdentityResourceId.equals(other$userAssignedIdentityResourceId)) {
                    return false;
                }
                String this$storageAccountConnectionStringName = this.getStorageAccountConnectionStringName();
                String other$storageAccountConnectionStringName = other.getStorageAccountConnectionStringName();
                return !(this$storageAccountConnectionStringName == null ? other$storageAccountConnectionStringName != null : !this$storageAccountConnectionStringName.equals(other$storageAccountConnectionStringName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Authentication;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StorageAuthenticationMethod $type = this.getType();
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $userAssignedIdentityResourceId = this.getUserAssignedIdentityResourceId();
                result = result * 59 + ($userAssignedIdentityResourceId == null ? 43 : $userAssignedIdentityResourceId.hashCode());
                String $storageAccountConnectionStringName = this.getStorageAccountConnectionStringName();
                result = result * 59 + ($storageAccountConnectionStringName == null ? 43 : $storageAccountConnectionStringName.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "FunctionAppConfig.Storage.Authentication(type=" + (Object)((Object)this.getType()) + ", userAssignedIdentityResourceId=" + this.getUserAssignedIdentityResourceId() + ", storageAccountConnectionStringName=" + this.getStorageAccountConnectionStringName() + ")";
            }

            @Generated
            public Authentication() {
                this.type = Authentication.$default$type();
                this.storageAccountConnectionStringName = Authentication.$default$storageAccountConnectionStringName();
            }

            @Generated
            public Authentication(StorageAuthenticationMethod type, String userAssignedIdentityResourceId, String storageAccountConnectionStringName) {
                this.type = type;
                this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
                this.storageAccountConnectionStringName = storageAccountConnectionStringName;
            }

            @Generated
            public static class AuthenticationBuilder {
                @Generated
                private boolean type$set;
                @Generated
                private StorageAuthenticationMethod type$value;
                @Generated
                private String userAssignedIdentityResourceId;
                @Generated
                private boolean storageAccountConnectionStringName$set;
                @Generated
                private String storageAccountConnectionStringName$value;

                @Generated
                AuthenticationBuilder() {
                }

                @Generated
                public AuthenticationBuilder type(StorageAuthenticationMethod type) {
                    this.type$value = type;
                    this.type$set = true;
                    return this;
                }

                @Generated
                public AuthenticationBuilder userAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
                    this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
                    return this;
                }

                @Generated
                public AuthenticationBuilder storageAccountConnectionStringName(String storageAccountConnectionStringName) {
                    this.storageAccountConnectionStringName$value = storageAccountConnectionStringName;
                    this.storageAccountConnectionStringName$set = true;
                    return this;
                }

                @Generated
                public Authentication build() {
                    StorageAuthenticationMethod type$value = this.type$value;
                    if (!this.type$set) {
                        type$value = Authentication.$default$type();
                    }
                    String storageAccountConnectionStringName$value = this.storageAccountConnectionStringName$value;
                    if (!this.storageAccountConnectionStringName$set) {
                        storageAccountConnectionStringName$value = Authentication.$default$storageAccountConnectionStringName();
                    }
                    return new Authentication(type$value, this.userAssignedIdentityResourceId, storageAccountConnectionStringName$value);
                }

                @Generated
                public String toString() {
                    return "FunctionAppConfig.Storage.Authentication.AuthenticationBuilder(type$value=" + (Object)((Object)this.type$value) + ", userAssignedIdentityResourceId=" + this.userAssignedIdentityResourceId + ", storageAccountConnectionStringName$value=" + this.storageAccountConnectionStringName$value + ")";
                }
            }
        }
    }
}

