/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.resources.fluentcore.arm.models.HasResourceGroup;
import com.azure.resourcemanager.storage.StorageManager;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.StorageAuthenticationMethod;
import com.microsoft.azure.toolkit.lib.storage.AzureStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FlexConsumptionConfiguration {
    public static final int DEFAULT_INSTANCE_SIZE = 2048;
    public static final FlexConsumptionConfiguration DEFAULT_CONFIGURATION = FlexConsumptionConfiguration.builder().authenticationMethod(StorageAuthenticationMethod.StorageAccountConnectionString).storageAccountConnectionString("DEPLOYMENT_STORAGE_CONNECTION_STRING").instanceSize(2048).maximumInstances(100).build();
    private String deploymentResourceGroup;
    private String deploymentAccount;
    private String deploymentContainer;
    private StorageAuthenticationMethod authenticationMethod;
    private String userAssignedIdentityResourceId;
    private String storageAccountConnectionString;
    private Integer instanceSize;
    private Integer httpInstanceConcurrency;
    private Map<String, String> alwaysReadyInstances;
    private Integer maximumInstances;
    private FunctionAppConfig flexFunctionAppConfig;

    public boolean isEmpty() {
        return ObjectUtils.allNull((Object[])new Object[]{this.instanceSize, this.alwaysReadyInstances, this.maximumInstances});
    }

    public FunctionAppConfig.FunctionAlwaysReadyConfig[] getAlwaysReadyInstances() {
        if (MapUtils.isEmpty(this.alwaysReadyInstances)) {
            return null;
        }
        return (FunctionAppConfig.FunctionAlwaysReadyConfig[])this.alwaysReadyInstances.entrySet().stream().map(entry -> FunctionAppConfig.FunctionAlwaysReadyConfig.builder().name((String)entry.getKey()).instanceCount(Integer.valueOf((String)entry.getValue())).build()).toArray(FunctionAppConfig.FunctionAlwaysReadyConfig[]::new);
    }

    @Nullable
    public static FlexConsumptionConfiguration fromFunctionAppBase(@Nonnull FunctionAppBase<?, ?, ?> app) {
        FunctionAppConfig config = app.getFlexConsumptionAppConfig();
        if (Objects.isNull(config)) {
            return null;
        }
        FlexConsumptionConfigurationBuilder builder = FlexConsumptionConfiguration.builder();
        FunctionAppConfig.Storage storage = config.getDeployment().getStorage();
        Optional.ofNullable(storage.getValue()).ifPresent(value -> {
            builder.deploymentAccount(FlexConsumptionConfiguration.parseStorageAccountFromBlobUrl(value));
            builder.deploymentContainer(FlexConsumptionConfiguration.parseContainerFromBlobUrl(value));
            builder.deploymentResourceGroup(FlexConsumptionConfiguration.getStorageAccountResourceGroup(app, builder.deploymentAccount));
        });
        Optional.ofNullable(storage.getAuthentication()).ifPresent(auth -> {
            builder.authenticationMethod(auth.getType());
            builder.userAssignedIdentityResourceId(auth.getUserAssignedIdentityResourceId());
            builder.storageAccountConnectionString(auth.getStorageAccountConnectionStringName());
        });
        FunctionAppConfig.FunctionScaleAndConcurrency scale = config.getScaleAndConcurrency();
        builder.instanceSize(scale.getInstanceMemoryMB());
        builder.maximumInstances(scale.getMaximumInstanceCount());
        Integer httpInstanceConcurrency = Optional.ofNullable(scale.getTriggers()).map(FunctionAppConfig.FunctionTriggers::getHttp).map(FunctionAppConfig.FunctionHttpTriggers::getPerInstanceConcurrency).orElse(null);
        builder.httpInstanceConcurrency(httpInstanceConcurrency);
        HashMap<String, String> alwaysReady = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])scale.getAlwaysReady())) {
            Arrays.stream(scale.getAlwaysReady()).forEach(c -> alwaysReady.put(c.getName(), String.valueOf(c.getInstanceCount())));
        }
        builder.alwaysReadyInstances(alwaysReady);
        return builder.build();
    }

    private static String getStorageAccountResourceGroup(@Nonnull FunctionAppBase<?, ?, ?> app, String deploymentAccount) {
        StorageManager remote = (StorageManager)((StorageServiceSubscription)((AzureStorageAccount)Azure.az(AzureStorageAccount.class)).forSubscription(app.getSubscriptionId())).getRemote();
        return Objects.requireNonNull(remote).storageAccounts().list().stream().collect(Collectors.toList()).stream().filter(account -> account.name().equals(deploymentAccount)).findFirst().map(HasResourceGroup::resourceGroupName).orElse(app.getResourceGroupName());
    }

    private static String parseStorageAccountFromBlobUrl(@Nonnull String blobUrl) {
        String[] parts = blobUrl.split("/", 4);
        if (parts.length < 3) {
            return null;
        }
        return parts[2].split("\\.")[0];
    }

    private static String parseContainerFromBlobUrl(@Nonnull String blobUrl) {
        String[] parts = blobUrl.split("/", 4);
        if (parts.length < 4) {
            return null;
        }
        return parts[3];
    }

    @Generated
    public static FlexConsumptionConfigurationBuilder builder() {
        return new FlexConsumptionConfigurationBuilder();
    }

    @Generated
    public String getDeploymentResourceGroup() {
        return this.deploymentResourceGroup;
    }

    @Generated
    public String getDeploymentAccount() {
        return this.deploymentAccount;
    }

    @Generated
    public String getDeploymentContainer() {
        return this.deploymentContainer;
    }

    @Generated
    public StorageAuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Generated
    public String getUserAssignedIdentityResourceId() {
        return this.userAssignedIdentityResourceId;
    }

    @Generated
    public String getStorageAccountConnectionString() {
        return this.storageAccountConnectionString;
    }

    @Generated
    public Integer getInstanceSize() {
        return this.instanceSize;
    }

    @Generated
    public Integer getHttpInstanceConcurrency() {
        return this.httpInstanceConcurrency;
    }

    @Generated
    public Integer getMaximumInstances() {
        return this.maximumInstances;
    }

    @Generated
    public FunctionAppConfig getFlexFunctionAppConfig() {
        return this.flexFunctionAppConfig;
    }

    @Generated
    public void setDeploymentResourceGroup(String deploymentResourceGroup) {
        this.deploymentResourceGroup = deploymentResourceGroup;
    }

    @Generated
    public void setDeploymentAccount(String deploymentAccount) {
        this.deploymentAccount = deploymentAccount;
    }

    @Generated
    public void setDeploymentContainer(String deploymentContainer) {
        this.deploymentContainer = deploymentContainer;
    }

    @Generated
    public void setAuthenticationMethod(StorageAuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @Generated
    public void setUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
        this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
    }

    @Generated
    public void setStorageAccountConnectionString(String storageAccountConnectionString) {
        this.storageAccountConnectionString = storageAccountConnectionString;
    }

    @Generated
    public void setInstanceSize(Integer instanceSize) {
        this.instanceSize = instanceSize;
    }

    @Generated
    public void setHttpInstanceConcurrency(Integer httpInstanceConcurrency) {
        this.httpInstanceConcurrency = httpInstanceConcurrency;
    }

    @Generated
    public void setAlwaysReadyInstances(Map<String, String> alwaysReadyInstances) {
        this.alwaysReadyInstances = alwaysReadyInstances;
    }

    @Generated
    public void setMaximumInstances(Integer maximumInstances) {
        this.maximumInstances = maximumInstances;
    }

    @Generated
    public void setFlexFunctionAppConfig(FunctionAppConfig flexFunctionAppConfig) {
        this.flexFunctionAppConfig = flexFunctionAppConfig;
    }

    @Generated
    public FlexConsumptionConfiguration() {
    }

    @Generated
    public FlexConsumptionConfiguration(String deploymentResourceGroup, String deploymentAccount, String deploymentContainer, StorageAuthenticationMethod authenticationMethod, String userAssignedIdentityResourceId, String storageAccountConnectionString, Integer instanceSize, Integer httpInstanceConcurrency, Map<String, String> alwaysReadyInstances, Integer maximumInstances, FunctionAppConfig flexFunctionAppConfig) {
        this.deploymentResourceGroup = deploymentResourceGroup;
        this.deploymentAccount = deploymentAccount;
        this.deploymentContainer = deploymentContainer;
        this.authenticationMethod = authenticationMethod;
        this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
        this.storageAccountConnectionString = storageAccountConnectionString;
        this.instanceSize = instanceSize;
        this.httpInstanceConcurrency = httpInstanceConcurrency;
        this.alwaysReadyInstances = alwaysReadyInstances;
        this.maximumInstances = maximumInstances;
        this.flexFunctionAppConfig = flexFunctionAppConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlexConsumptionConfiguration)) {
            return false;
        }
        FlexConsumptionConfiguration other = (FlexConsumptionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$instanceSize = this.getInstanceSize();
        Integer other$instanceSize = other.getInstanceSize();
        if (this$instanceSize == null ? other$instanceSize != null : !((Object)this$instanceSize).equals(other$instanceSize)) {
            return false;
        }
        Integer this$httpInstanceConcurrency = this.getHttpInstanceConcurrency();
        Integer other$httpInstanceConcurrency = other.getHttpInstanceConcurrency();
        if (this$httpInstanceConcurrency == null ? other$httpInstanceConcurrency != null : !((Object)this$httpInstanceConcurrency).equals(other$httpInstanceConcurrency)) {
            return false;
        }
        Integer this$maximumInstances = this.getMaximumInstances();
        Integer other$maximumInstances = other.getMaximumInstances();
        if (this$maximumInstances == null ? other$maximumInstances != null : !((Object)this$maximumInstances).equals(other$maximumInstances)) {
            return false;
        }
        String this$deploymentResourceGroup = this.getDeploymentResourceGroup();
        String other$deploymentResourceGroup = other.getDeploymentResourceGroup();
        if (this$deploymentResourceGroup == null ? other$deploymentResourceGroup != null : !this$deploymentResourceGroup.equals(other$deploymentResourceGroup)) {
            return false;
        }
        String this$deploymentAccount = this.getDeploymentAccount();
        String other$deploymentAccount = other.getDeploymentAccount();
        if (this$deploymentAccount == null ? other$deploymentAccount != null : !this$deploymentAccount.equals(other$deploymentAccount)) {
            return false;
        }
        String this$deploymentContainer = this.getDeploymentContainer();
        String other$deploymentContainer = other.getDeploymentContainer();
        if (this$deploymentContainer == null ? other$deploymentContainer != null : !this$deploymentContainer.equals(other$deploymentContainer)) {
            return false;
        }
        StorageAuthenticationMethod this$authenticationMethod = this.getAuthenticationMethod();
        StorageAuthenticationMethod other$authenticationMethod = other.getAuthenticationMethod();
        if (this$authenticationMethod == null ? other$authenticationMethod != null : !((Object)((Object)this$authenticationMethod)).equals((Object)other$authenticationMethod)) {
            return false;
        }
        String this$userAssignedIdentityResourceId = this.getUserAssignedIdentityResourceId();
        String other$userAssignedIdentityResourceId = other.getUserAssignedIdentityResourceId();
        if (this$userAssignedIdentityResourceId == null ? other$userAssignedIdentityResourceId != null : !this$userAssignedIdentityResourceId.equals(other$userAssignedIdentityResourceId)) {
            return false;
        }
        String this$storageAccountConnectionString = this.getStorageAccountConnectionString();
        String other$storageAccountConnectionString = other.getStorageAccountConnectionString();
        if (this$storageAccountConnectionString == null ? other$storageAccountConnectionString != null : !this$storageAccountConnectionString.equals(other$storageAccountConnectionString)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAlwaysReadyInstances(), other.getAlwaysReadyInstances())) {
            return false;
        }
        FunctionAppConfig this$flexFunctionAppConfig = this.getFlexFunctionAppConfig();
        FunctionAppConfig other$flexFunctionAppConfig = other.getFlexFunctionAppConfig();
        return !(this$flexFunctionAppConfig == null ? other$flexFunctionAppConfig != null : !((Object)this$flexFunctionAppConfig).equals(other$flexFunctionAppConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlexConsumptionConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $instanceSize = this.getInstanceSize();
        result = result * 59 + ($instanceSize == null ? 43 : ((Object)$instanceSize).hashCode());
        Integer $httpInstanceConcurrency = this.getHttpInstanceConcurrency();
        result = result * 59 + ($httpInstanceConcurrency == null ? 43 : ((Object)$httpInstanceConcurrency).hashCode());
        Integer $maximumInstances = this.getMaximumInstances();
        result = result * 59 + ($maximumInstances == null ? 43 : ((Object)$maximumInstances).hashCode());
        String $deploymentResourceGroup = this.getDeploymentResourceGroup();
        result = result * 59 + ($deploymentResourceGroup == null ? 43 : $deploymentResourceGroup.hashCode());
        String $deploymentAccount = this.getDeploymentAccount();
        result = result * 59 + ($deploymentAccount == null ? 43 : $deploymentAccount.hashCode());
        String $deploymentContainer = this.getDeploymentContainer();
        result = result * 59 + ($deploymentContainer == null ? 43 : $deploymentContainer.hashCode());
        StorageAuthenticationMethod $authenticationMethod = this.getAuthenticationMethod();
        result = result * 59 + ($authenticationMethod == null ? 43 : ((Object)((Object)$authenticationMethod)).hashCode());
        String $userAssignedIdentityResourceId = this.getUserAssignedIdentityResourceId();
        result = result * 59 + ($userAssignedIdentityResourceId == null ? 43 : $userAssignedIdentityResourceId.hashCode());
        String $storageAccountConnectionString = this.getStorageAccountConnectionString();
        result = result * 59 + ($storageAccountConnectionString == null ? 43 : $storageAccountConnectionString.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAlwaysReadyInstances());
        FunctionAppConfig $flexFunctionAppConfig = this.getFlexFunctionAppConfig();
        result = result * 59 + ($flexFunctionAppConfig == null ? 43 : ((Object)$flexFunctionAppConfig).hashCode());
        return result;
    }

    @Generated
    public static class FlexConsumptionConfigurationBuilder {
        @Generated
        private String deploymentResourceGroup;
        @Generated
        private String deploymentAccount;
        @Generated
        private String deploymentContainer;
        @Generated
        private StorageAuthenticationMethod authenticationMethod;
        @Generated
        private String userAssignedIdentityResourceId;
        @Generated
        private String storageAccountConnectionString;
        @Generated
        private Integer instanceSize;
        @Generated
        private Integer httpInstanceConcurrency;
        @Generated
        private Map<String, String> alwaysReadyInstances;
        @Generated
        private Integer maximumInstances;
        @Generated
        private FunctionAppConfig flexFunctionAppConfig;

        @Generated
        FlexConsumptionConfigurationBuilder() {
        }

        @Generated
        public FlexConsumptionConfigurationBuilder deploymentResourceGroup(String deploymentResourceGroup) {
            this.deploymentResourceGroup = deploymentResourceGroup;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder deploymentAccount(String deploymentAccount) {
            this.deploymentAccount = deploymentAccount;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder deploymentContainer(String deploymentContainer) {
            this.deploymentContainer = deploymentContainer;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder authenticationMethod(StorageAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder userAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
            this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder storageAccountConnectionString(String storageAccountConnectionString) {
            this.storageAccountConnectionString = storageAccountConnectionString;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder instanceSize(Integer instanceSize) {
            this.instanceSize = instanceSize;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder httpInstanceConcurrency(Integer httpInstanceConcurrency) {
            this.httpInstanceConcurrency = httpInstanceConcurrency;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder alwaysReadyInstances(Map<String, String> alwaysReadyInstances) {
            this.alwaysReadyInstances = alwaysReadyInstances;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder maximumInstances(Integer maximumInstances) {
            this.maximumInstances = maximumInstances;
            return this;
        }

        @Generated
        public FlexConsumptionConfigurationBuilder flexFunctionAppConfig(FunctionAppConfig flexFunctionAppConfig) {
            this.flexFunctionAppConfig = flexFunctionAppConfig;
            return this;
        }

        @Generated
        public FlexConsumptionConfiguration build() {
            return new FlexConsumptionConfiguration(this.deploymentResourceGroup, this.deploymentAccount, this.deploymentContainer, this.authenticationMethod, this.userAssignedIdentityResourceId, this.storageAccountConnectionString, this.instanceSize, this.httpInstanceConcurrency, this.alwaysReadyInstances, this.maximumInstances, this.flexFunctionAppConfig);
        }

        @Generated
        public String toString() {
            return "FlexConsumptionConfiguration.FlexConsumptionConfigurationBuilder(deploymentResourceGroup=" + this.deploymentResourceGroup + ", deploymentAccount=" + this.deploymentAccount + ", deploymentContainer=" + this.deploymentContainer + ", authenticationMethod=" + (Object)((Object)this.authenticationMethod) + ", userAssignedIdentityResourceId=" + this.userAssignedIdentityResourceId + ", storageAccountConnectionString=" + this.storageAccountConnectionString + ", instanceSize=" + this.instanceSize + ", httpInstanceConcurrency=" + this.httpInstanceConcurrency + ", alwaysReadyInstances=" + this.alwaysReadyInstances + ", maximumInstances=" + this.maximumInstances + ", flexFunctionAppConfig=" + this.flexFunctionAppConfig + ")";
        }
    }
}

