/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.model.DeploymentBuildStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.ErrorEntity;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public class CsmDeploymentStatus {
    private String deploymentId;
    private DeploymentBuildStatus status;
    private Integer numberOfInstancesInProgress;
    private Integer numberOfInstancesSuccessful;
    private Integer numberOfInstancesFailed;
    private List<String> failedInstancesLogs;
    private List<ErrorEntity> errors;

    public int getTotalInstanceCount() {
        return Stream.of(this.numberOfInstancesInProgress, this.numberOfInstancesFailed, this.numberOfInstancesSuccessful).filter(i -> i != null).mapToInt(Integer::intValue).sum();
    }

    @Generated
    CsmDeploymentStatus(String deploymentId, DeploymentBuildStatus status, Integer numberOfInstancesInProgress, Integer numberOfInstancesSuccessful, Integer numberOfInstancesFailed, List<String> failedInstancesLogs, List<ErrorEntity> errors) {
        this.deploymentId = deploymentId;
        this.status = status;
        this.numberOfInstancesInProgress = numberOfInstancesInProgress;
        this.numberOfInstancesSuccessful = numberOfInstancesSuccessful;
        this.numberOfInstancesFailed = numberOfInstancesFailed;
        this.failedInstancesLogs = failedInstancesLogs;
        this.errors = errors;
    }

    @Generated
    public static CsmDeploymentStatusBuilder builder() {
        return new CsmDeploymentStatusBuilder();
    }

    @Generated
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Generated
    public DeploymentBuildStatus getStatus() {
        return this.status;
    }

    @Generated
    public Integer getNumberOfInstancesInProgress() {
        return this.numberOfInstancesInProgress;
    }

    @Generated
    public Integer getNumberOfInstancesSuccessful() {
        return this.numberOfInstancesSuccessful;
    }

    @Generated
    public Integer getNumberOfInstancesFailed() {
        return this.numberOfInstancesFailed;
    }

    @Generated
    public List<String> getFailedInstancesLogs() {
        return this.failedInstancesLogs;
    }

    @Generated
    public List<ErrorEntity> getErrors() {
        return this.errors;
    }

    @Generated
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Generated
    public void setStatus(DeploymentBuildStatus status) {
        this.status = status;
    }

    @Generated
    public void setNumberOfInstancesInProgress(Integer numberOfInstancesInProgress) {
        this.numberOfInstancesInProgress = numberOfInstancesInProgress;
    }

    @Generated
    public void setNumberOfInstancesSuccessful(Integer numberOfInstancesSuccessful) {
        this.numberOfInstancesSuccessful = numberOfInstancesSuccessful;
    }

    @Generated
    public void setNumberOfInstancesFailed(Integer numberOfInstancesFailed) {
        this.numberOfInstancesFailed = numberOfInstancesFailed;
    }

    @Generated
    public void setFailedInstancesLogs(List<String> failedInstancesLogs) {
        this.failedInstancesLogs = failedInstancesLogs;
    }

    @Generated
    public void setErrors(List<ErrorEntity> errors) {
        this.errors = errors;
    }

    @Generated
    public String toString() {
        return "CsmDeploymentStatus(deploymentId=" + this.getDeploymentId() + ", status=" + this.getStatus() + ", numberOfInstancesInProgress=" + this.getNumberOfInstancesInProgress() + ", numberOfInstancesSuccessful=" + this.getNumberOfInstancesSuccessful() + ", numberOfInstancesFailed=" + this.getNumberOfInstancesFailed() + ", failedInstancesLogs=" + this.getFailedInstancesLogs() + ", errors=" + this.getErrors() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsmDeploymentStatus)) {
            return false;
        }
        CsmDeploymentStatus other = (CsmDeploymentStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$numberOfInstancesInProgress = this.getNumberOfInstancesInProgress();
        Integer other$numberOfInstancesInProgress = other.getNumberOfInstancesInProgress();
        if (this$numberOfInstancesInProgress == null ? other$numberOfInstancesInProgress != null : !((Object)this$numberOfInstancesInProgress).equals(other$numberOfInstancesInProgress)) {
            return false;
        }
        Integer this$numberOfInstancesSuccessful = this.getNumberOfInstancesSuccessful();
        Integer other$numberOfInstancesSuccessful = other.getNumberOfInstancesSuccessful();
        if (this$numberOfInstancesSuccessful == null ? other$numberOfInstancesSuccessful != null : !((Object)this$numberOfInstancesSuccessful).equals(other$numberOfInstancesSuccessful)) {
            return false;
        }
        Integer this$numberOfInstancesFailed = this.getNumberOfInstancesFailed();
        Integer other$numberOfInstancesFailed = other.getNumberOfInstancesFailed();
        if (this$numberOfInstancesFailed == null ? other$numberOfInstancesFailed != null : !((Object)this$numberOfInstancesFailed).equals(other$numberOfInstancesFailed)) {
            return false;
        }
        String this$deploymentId = this.getDeploymentId();
        String other$deploymentId = other.getDeploymentId();
        if (this$deploymentId == null ? other$deploymentId != null : !this$deploymentId.equals(other$deploymentId)) {
            return false;
        }
        DeploymentBuildStatus this$status = this.getStatus();
        DeploymentBuildStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<String> this$failedInstancesLogs = this.getFailedInstancesLogs();
        List<String> other$failedInstancesLogs = other.getFailedInstancesLogs();
        if (this$failedInstancesLogs == null ? other$failedInstancesLogs != null : !((Object)this$failedInstancesLogs).equals(other$failedInstancesLogs)) {
            return false;
        }
        List<ErrorEntity> this$errors = this.getErrors();
        List<ErrorEntity> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CsmDeploymentStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $numberOfInstancesInProgress = this.getNumberOfInstancesInProgress();
        result = result * 59 + ($numberOfInstancesInProgress == null ? 43 : ((Object)$numberOfInstancesInProgress).hashCode());
        Integer $numberOfInstancesSuccessful = this.getNumberOfInstancesSuccessful();
        result = result * 59 + ($numberOfInstancesSuccessful == null ? 43 : ((Object)$numberOfInstancesSuccessful).hashCode());
        Integer $numberOfInstancesFailed = this.getNumberOfInstancesFailed();
        result = result * 59 + ($numberOfInstancesFailed == null ? 43 : ((Object)$numberOfInstancesFailed).hashCode());
        String $deploymentId = this.getDeploymentId();
        result = result * 59 + ($deploymentId == null ? 43 : $deploymentId.hashCode());
        DeploymentBuildStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<String> $failedInstancesLogs = this.getFailedInstancesLogs();
        result = result * 59 + ($failedInstancesLogs == null ? 43 : ((Object)$failedInstancesLogs).hashCode());
        List<ErrorEntity> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public static class CsmDeploymentStatusBuilder {
        @Generated
        private String deploymentId;
        @Generated
        private DeploymentBuildStatus status;
        @Generated
        private Integer numberOfInstancesInProgress;
        @Generated
        private Integer numberOfInstancesSuccessful;
        @Generated
        private Integer numberOfInstancesFailed;
        @Generated
        private List<String> failedInstancesLogs;
        @Generated
        private List<ErrorEntity> errors;

        @Generated
        CsmDeploymentStatusBuilder() {
        }

        @Generated
        public CsmDeploymentStatusBuilder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        @Generated
        public CsmDeploymentStatusBuilder status(DeploymentBuildStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public CsmDeploymentStatusBuilder numberOfInstancesInProgress(Integer numberOfInstancesInProgress) {
            this.numberOfInstancesInProgress = numberOfInstancesInProgress;
            return this;
        }

        @Generated
        public CsmDeploymentStatusBuilder numberOfInstancesSuccessful(Integer numberOfInstancesSuccessful) {
            this.numberOfInstancesSuccessful = numberOfInstancesSuccessful;
            return this;
        }

        @Generated
        public CsmDeploymentStatusBuilder numberOfInstancesFailed(Integer numberOfInstancesFailed) {
            this.numberOfInstancesFailed = numberOfInstancesFailed;
            return this;
        }

        @Generated
        public CsmDeploymentStatusBuilder failedInstancesLogs(List<String> failedInstancesLogs) {
            this.failedInstancesLogs = failedInstancesLogs;
            return this;
        }

        @Generated
        public CsmDeploymentStatusBuilder errors(List<ErrorEntity> errors) {
            this.errors = errors;
            return this;
        }

        @Generated
        public CsmDeploymentStatus build() {
            return new CsmDeploymentStatus(this.deploymentId, this.status, this.numberOfInstancesInProgress, this.numberOfInstancesSuccessful, this.numberOfInstancesFailed, this.failedInstancesLogs, this.errors);
        }

        @Generated
        public String toString() {
            return "CsmDeploymentStatus.CsmDeploymentStatusBuilder(deploymentId=" + this.deploymentId + ", status=" + this.status + ", numberOfInstancesInProgress=" + this.numberOfInstancesInProgress + ", numberOfInstancesSuccessful=" + this.numberOfInstancesSuccessful + ", numberOfInstancesFailed=" + this.numberOfInstancesFailed + ", failedInstancesLogs=" + this.failedInstancesLogs + ", errors=" + this.errors + ")";
        }
    }
}

