/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import java.util.Objects;
import lombok.Generated;

public class AppServiceFile {
    private String name;
    private long size;
    private String mtime;
    private String crtime;
    private String mime;
    private String href;
    private String path;
    private AppServiceAppBase<?, ?, ?> app;

    public String getId() {
        return String.format("<%s>/%s", this.getApp().id(), this.getPath());
    }

    public String getFullName() {
        return String.format("<%s>/%s", this.getApp().name(), this.getName());
    }

    public Type getType() {
        return Objects.equals("inode/directory", this.mime) ? Type.DIRECTORY : Type.FILE;
    }

    @Generated
    public AppServiceFile withName(String name) {
        return this.name == name ? this : new AppServiceFile(name, this.size, this.mtime, this.crtime, this.mime, this.href, this.path, this.app);
    }

    @Generated
    public AppServiceFile withSize(long size) {
        return this.size == size ? this : new AppServiceFile(this.name, size, this.mtime, this.crtime, this.mime, this.href, this.path, this.app);
    }

    @Generated
    public AppServiceFile withMtime(String mtime) {
        return this.mtime == mtime ? this : new AppServiceFile(this.name, this.size, mtime, this.crtime, this.mime, this.href, this.path, this.app);
    }

    @Generated
    public AppServiceFile withCrtime(String crtime) {
        return this.crtime == crtime ? this : new AppServiceFile(this.name, this.size, this.mtime, crtime, this.mime, this.href, this.path, this.app);
    }

    @Generated
    public AppServiceFile withMime(String mime) {
        return this.mime == mime ? this : new AppServiceFile(this.name, this.size, this.mtime, this.crtime, mime, this.href, this.path, this.app);
    }

    @Generated
    public AppServiceFile withHref(String href) {
        return this.href == href ? this : new AppServiceFile(this.name, this.size, this.mtime, this.crtime, this.mime, href, this.path, this.app);
    }

    @Generated
    public AppServiceFile withPath(String path) {
        return this.path == path ? this : new AppServiceFile(this.name, this.size, this.mtime, this.crtime, this.mime, this.href, path, this.app);
    }

    @Generated
    public AppServiceFile withApp(AppServiceAppBase<?, ?, ?> app) {
        return this.app == app ? this : new AppServiceFile(this.name, this.size, this.mtime, this.crtime, this.mime, this.href, this.path, app);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public String getMtime() {
        return this.mtime;
    }

    @Generated
    public String getCrtime() {
        return this.crtime;
    }

    @Generated
    public String getMime() {
        return this.mime;
    }

    @Generated
    public String getHref() {
        return this.href;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public AppServiceAppBase<?, ?, ?> getApp() {
        return this.app;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setMtime(String mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setCrtime(String crtime) {
        this.crtime = crtime;
    }

    @Generated
    public void setMime(String mime) {
        this.mime = mime;
    }

    @Generated
    public void setHref(String href) {
        this.href = href;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setApp(AppServiceAppBase<?, ?, ?> app) {
        this.app = app;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppServiceFile)) {
            return false;
        }
        AppServiceFile other = (AppServiceFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mtime = this.getMtime();
        String other$mtime = other.getMtime();
        if (this$mtime == null ? other$mtime != null : !this$mtime.equals(other$mtime)) {
            return false;
        }
        String this$crtime = this.getCrtime();
        String other$crtime = other.getCrtime();
        if (this$crtime == null ? other$crtime != null : !this$crtime.equals(other$crtime)) {
            return false;
        }
        String this$mime = this.getMime();
        String other$mime = other.getMime();
        if (this$mime == null ? other$mime != null : !this$mime.equals(other$mime)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        AppServiceAppBase<?, ?, ?> this$app = this.getApp();
        AppServiceAppBase<?, ?, ?> other$app = other.getApp();
        return !(this$app == null ? other$app != null : !((Object)this$app).equals(other$app));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppServiceFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mtime = this.getMtime();
        result = result * 59 + ($mtime == null ? 43 : $mtime.hashCode());
        String $crtime = this.getCrtime();
        result = result * 59 + ($crtime == null ? 43 : $crtime.hashCode());
        String $mime = this.getMime();
        result = result * 59 + ($mime == null ? 43 : $mime.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        AppServiceAppBase<?, ?, ?> $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : ((Object)$app).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AppServiceFile(name=" + this.getName() + ", size=" + this.getSize() + ", mtime=" + this.getMtime() + ", crtime=" + this.getCrtime() + ", mime=" + this.getMime() + ", href=" + this.getHref() + ", path=" + this.getPath() + ", app=" + this.getApp() + ")";
    }

    @Generated
    public AppServiceFile(String name, long size, String mtime, String crtime, String mime, String href, String path, AppServiceAppBase<?, ?, ?> app) {
        this.name = name;
        this.size = size;
        this.mtime = mtime;
        this.crtime = crtime;
        this.mime = mime;
        this.href = href;
        this.path = path;
        this.app = app;
    }

    @Generated
    public AppServiceFile() {
    }

    public static enum Type {
        DIRECTORY,
        FILE;

    }
}

