/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function.core;

import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionAnnotationClass;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FunctionAnnotation {
    private FunctionAnnotationClass annotationClass;
    private Map<String, Object> properties;
    private Map<String, Object> defaultProperties;

    public Map<String, Object> getAnnotationProperties(boolean includeDefaultValue) {
        if (!includeDefaultValue) {
            return this.properties;
        }
        HashMap<String, Object> res = new HashMap<String, Object>(this.properties);
        this.defaultProperties.forEach(res::putIfAbsent);
        return res;
    }

    public Map<String, Object> getDeclaredAnnotationProperties() {
        return this.getAnnotationProperties(false);
    }

    public Map<String, Object> getAllAnnotationProperties() {
        return this.getAnnotationProperties(true);
    }

    public Map<String, Object> getPropertiesWithRequiredProperties(List<String> requiredProperties) {
        HashMap<String, Object> copiedMap = new HashMap<String, Object>(this.properties);
        if (requiredProperties != null) {
            requiredProperties.forEach(key -> {
                if (this.defaultProperties.containsKey(key)) {
                    copiedMap.putIfAbsent((String)key, this.defaultProperties.get(key));
                }
            });
        }
        return copiedMap;
    }

    public boolean isAnnotationType(@Nonnull Class<? extends Annotation> clz) {
        return StringUtils.equals((CharSequence)this.getAnnotationClassName(), (CharSequence)clz.getCanonicalName());
    }

    public boolean isAnnotationType(@Nonnull String className) {
        return StringUtils.equals((CharSequence)this.getAnnotationClassName(), (CharSequence)className);
    }

    public Object get(String key, boolean includeDefaultValue) {
        if (includeDefaultValue) {
            return this.properties.getOrDefault(key, this.defaultProperties.get(key));
        }
        return this.properties.get(key);
    }

    public String getStringValue(String key, boolean includeDefaultValue) {
        Object value = this.get(key, includeDefaultValue);
        if (value != null && !(value instanceof String)) {
            throw new AzureToolkitRuntimeException(String.format("Unexpected key '%s' with type '%s'", key, value.getClass().getSimpleName()));
        }
        return value == null ? null : (String)value;
    }

    public String getAnnotationClassName() {
        return this.annotationClass.getFullName();
    }

    @Generated
    public void setAnnotationClass(FunctionAnnotationClass annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Generated
    public FunctionAnnotationClass getAnnotationClass() {
        return this.annotationClass;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Generated
    public void setDefaultProperties(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }
}

