/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.config;

import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ApplicationInsightsConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ContainerAppFunctionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceConfig;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class FunctionAppConfig
extends AppServiceConfig {
    private String storageAccountName;
    private String storageAccountResourceGroup;
    private String environment;
    private ContainerAppsEnvironmentDraft.Config environmentConfig;
    private ContainerAppFunctionConfiguration containerConfiguration;
    private LogAnalyticsWorkspaceConfig workspaceConfig;
    private Boolean enableDistributedTracing;
    private ApplicationInsightsConfig applicationInsightsConfig;
    private FlexConsumptionConfiguration flexConsumptionConfiguration;
    private Boolean skipEndOfLifeValidation;

    public String environment() {
        return Optional.ofNullable(this.environmentConfig).map(ContainerAppsEnvironmentDraft.Config::getName).orElse(this.environment);
    }

    public FunctionAppConfig environment(String environment) {
        this.environment = environment;
        this.environmentConfig = new ContainerAppsEnvironmentDraft.Config();
        this.environmentConfig.setName(environment);
        return this;
    }

    public boolean disableAppInsights() {
        return Optional.ofNullable(this.applicationInsightsConfig).map(c -> BooleanUtils.isTrue((Boolean)c.getDisableAppInsights())).orElse(false);
    }

    @Nullable
    public String appInsightsInstance() {
        return Optional.ofNullable(this.applicationInsightsConfig).filter(c -> BooleanUtils.isNotTrue((Boolean)c.getDisableAppInsights())).map(ApplicationInsightsConfig::getName).orElse(null);
    }

    @Nullable
    public String appInsightsKey() {
        return Optional.ofNullable(this.applicationInsightsConfig).filter(c -> BooleanUtils.isNotTrue((Boolean)c.getDisableAppInsights())).map(ApplicationInsightsConfig::getInstrumentationKey).orElse(null);
    }

    @Nullable
    public LogAnalyticsWorkspaceConfig workspaceConfig() {
        return Optional.ofNullable(this.applicationInsightsConfig).filter(c -> BooleanUtils.isNotTrue((Boolean)c.getDisableAppInsights())).map(ApplicationInsightsConfig::getWorkspaceConfig).orElse(null);
    }

    public FunctionAppConfig disableAppInsights(Boolean disableAppInsights) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setDisableAppInsights(disableAppInsights);
        return this;
    }

    @Nonnull
    public FunctionAppConfig appInsightsInstance(String appInsightsInstance) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setName(appInsightsInstance);
        return this;
    }

    @Nonnull
    public FunctionAppConfig appInsightsKey(String key) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setInstrumentationKey(key);
        return this;
    }

    @Nonnull
    public FunctionAppConfig workspaceConfig(LogAnalyticsWorkspaceConfig workspaceConfig) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setWorkspaceConfig(workspaceConfig);
        return this;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getStorageAccountResourceGroup() {
        return this.storageAccountResourceGroup;
    }

    public Boolean getEnableDistributedTracing() {
        return this.enableDistributedTracing;
    }

    public ApplicationInsightsConfig getApplicationInsightsConfig() {
        return this.applicationInsightsConfig;
    }

    public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
        return this.flexConsumptionConfiguration;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public void setStorageAccountResourceGroup(String storageAccountResourceGroup) {
        this.storageAccountResourceGroup = storageAccountResourceGroup;
    }

    public void setEnableDistributedTracing(Boolean enableDistributedTracing) {
        this.enableDistributedTracing = enableDistributedTracing;
    }

    public void setApplicationInsightsConfig(ApplicationInsightsConfig applicationInsightsConfig) {
        this.applicationInsightsConfig = applicationInsightsConfig;
    }

    public void setFlexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.flexConsumptionConfiguration = flexConsumptionConfiguration;
    }

    public void setSkipEndOfLifeValidation(Boolean skipEndOfLifeValidation) {
        this.skipEndOfLifeValidation = skipEndOfLifeValidation;
    }

    public Boolean getSkipEndOfLifeValidation() {
        return this.skipEndOfLifeValidation;
    }

    @Generated
    private static Boolean $default$skipEndOfLifeValidation() {
        return Boolean.TRUE;
    }

    @Generated
    protected FunctionAppConfig(FunctionAppConfigBuilder<?, ?> b) {
        super(b);
        this.storageAccountName = ((FunctionAppConfigBuilder)b).storageAccountName;
        this.storageAccountResourceGroup = ((FunctionAppConfigBuilder)b).storageAccountResourceGroup;
        this.environment = ((FunctionAppConfigBuilder)b).environment;
        this.environmentConfig = ((FunctionAppConfigBuilder)b).environmentConfig;
        this.containerConfiguration = ((FunctionAppConfigBuilder)b).containerConfiguration;
        this.workspaceConfig = ((FunctionAppConfigBuilder)b).workspaceConfig;
        this.enableDistributedTracing = ((FunctionAppConfigBuilder)b).enableDistributedTracing;
        this.applicationInsightsConfig = ((FunctionAppConfigBuilder)b).applicationInsightsConfig;
        this.flexConsumptionConfiguration = ((FunctionAppConfigBuilder)b).flexConsumptionConfiguration;
        this.skipEndOfLifeValidation = ((FunctionAppConfigBuilder)b).skipEndOfLifeValidation$set ? ((FunctionAppConfigBuilder)b).skipEndOfLifeValidation$value : FunctionAppConfig.$default$skipEndOfLifeValidation();
    }

    @Generated
    public static FunctionAppConfigBuilder<?, ?> builder() {
        return new FunctionAppConfigBuilderImpl();
    }

    @Generated
    public FunctionAppConfigBuilder<?, ?> toBuilder() {
        return new FunctionAppConfigBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String storageAccountName() {
        return this.storageAccountName;
    }

    @Generated
    public String storageAccountResourceGroup() {
        return this.storageAccountResourceGroup;
    }

    @Generated
    public ContainerAppsEnvironmentDraft.Config environmentConfig() {
        return this.environmentConfig;
    }

    @Generated
    public ContainerAppFunctionConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    @Generated
    public Boolean enableDistributedTracing() {
        return this.enableDistributedTracing;
    }

    @Generated
    public ApplicationInsightsConfig applicationInsightsConfig() {
        return this.applicationInsightsConfig;
    }

    @Generated
    public FlexConsumptionConfiguration flexConsumptionConfiguration() {
        return this.flexConsumptionConfiguration;
    }

    @Generated
    public Boolean skipEndOfLifeValidation() {
        return this.skipEndOfLifeValidation;
    }

    @Generated
    public FunctionAppConfig storageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    @Generated
    public FunctionAppConfig storageAccountResourceGroup(String storageAccountResourceGroup) {
        this.storageAccountResourceGroup = storageAccountResourceGroup;
        return this;
    }

    @Generated
    public FunctionAppConfig environmentConfig(ContainerAppsEnvironmentDraft.Config environmentConfig) {
        this.environmentConfig = environmentConfig;
        return this;
    }

    @Generated
    public FunctionAppConfig containerConfiguration(ContainerAppFunctionConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    @Generated
    public FunctionAppConfig enableDistributedTracing(Boolean enableDistributedTracing) {
        this.enableDistributedTracing = enableDistributedTracing;
        return this;
    }

    @Generated
    public FunctionAppConfig applicationInsightsConfig(ApplicationInsightsConfig applicationInsightsConfig) {
        this.applicationInsightsConfig = applicationInsightsConfig;
        return this;
    }

    @Generated
    public FunctionAppConfig flexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.flexConsumptionConfiguration = flexConsumptionConfiguration;
        return this;
    }

    @Generated
    public FunctionAppConfig skipEndOfLifeValidation(Boolean skipEndOfLifeValidation) {
        this.skipEndOfLifeValidation = skipEndOfLifeValidation;
        return this;
    }

    @Generated
    public FunctionAppConfig() {
        this.skipEndOfLifeValidation = FunctionAppConfig.$default$skipEndOfLifeValidation();
    }

    @Generated
    public FunctionAppConfig(String storageAccountName, String storageAccountResourceGroup, String environment, ContainerAppsEnvironmentDraft.Config environmentConfig, ContainerAppFunctionConfiguration containerConfiguration, LogAnalyticsWorkspaceConfig workspaceConfig, Boolean enableDistributedTracing, ApplicationInsightsConfig applicationInsightsConfig, FlexConsumptionConfiguration flexConsumptionConfiguration, Boolean skipEndOfLifeValidation) {
        this.storageAccountName = storageAccountName;
        this.storageAccountResourceGroup = storageAccountResourceGroup;
        this.environment = environment;
        this.environmentConfig = environmentConfig;
        this.containerConfiguration = containerConfiguration;
        this.workspaceConfig = workspaceConfig;
        this.enableDistributedTracing = enableDistributedTracing;
        this.applicationInsightsConfig = applicationInsightsConfig;
        this.flexConsumptionConfiguration = flexConsumptionConfiguration;
        this.skipEndOfLifeValidation = skipEndOfLifeValidation;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionAppConfig)) {
            return false;
        }
        FunctionAppConfig other = (FunctionAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enableDistributedTracing = this.enableDistributedTracing();
        Boolean other$enableDistributedTracing = other.enableDistributedTracing();
        if (this$enableDistributedTracing == null ? other$enableDistributedTracing != null : !((Object)this$enableDistributedTracing).equals(other$enableDistributedTracing)) {
            return false;
        }
        Boolean this$skipEndOfLifeValidation = this.skipEndOfLifeValidation();
        Boolean other$skipEndOfLifeValidation = other.skipEndOfLifeValidation();
        if (this$skipEndOfLifeValidation == null ? other$skipEndOfLifeValidation != null : !((Object)this$skipEndOfLifeValidation).equals(other$skipEndOfLifeValidation)) {
            return false;
        }
        String this$storageAccountName = this.storageAccountName();
        String other$storageAccountName = other.storageAccountName();
        if (this$storageAccountName == null ? other$storageAccountName != null : !this$storageAccountName.equals(other$storageAccountName)) {
            return false;
        }
        String this$storageAccountResourceGroup = this.storageAccountResourceGroup();
        String other$storageAccountResourceGroup = other.storageAccountResourceGroup();
        if (this$storageAccountResourceGroup == null ? other$storageAccountResourceGroup != null : !this$storageAccountResourceGroup.equals(other$storageAccountResourceGroup)) {
            return false;
        }
        String this$environment = this.environment();
        String other$environment = other.environment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        ContainerAppsEnvironmentDraft.Config this$environmentConfig = this.environmentConfig();
        ContainerAppsEnvironmentDraft.Config other$environmentConfig = other.environmentConfig();
        if (this$environmentConfig == null ? other$environmentConfig != null : !this$environmentConfig.equals(other$environmentConfig)) {
            return false;
        }
        ContainerAppFunctionConfiguration this$containerConfiguration = this.containerConfiguration();
        ContainerAppFunctionConfiguration other$containerConfiguration = other.containerConfiguration();
        if (this$containerConfiguration == null ? other$containerConfiguration != null : !((Object)this$containerConfiguration).equals(other$containerConfiguration)) {
            return false;
        }
        LogAnalyticsWorkspaceConfig this$workspaceConfig = this.workspaceConfig();
        LogAnalyticsWorkspaceConfig other$workspaceConfig = other.workspaceConfig();
        if (this$workspaceConfig == null ? other$workspaceConfig != null : !this$workspaceConfig.equals(other$workspaceConfig)) {
            return false;
        }
        ApplicationInsightsConfig this$applicationInsightsConfig = this.applicationInsightsConfig();
        ApplicationInsightsConfig other$applicationInsightsConfig = other.applicationInsightsConfig();
        if (this$applicationInsightsConfig == null ? other$applicationInsightsConfig != null : !this$applicationInsightsConfig.equals(other$applicationInsightsConfig)) {
            return false;
        }
        FlexConsumptionConfiguration this$flexConsumptionConfiguration = this.flexConsumptionConfiguration();
        FlexConsumptionConfiguration other$flexConsumptionConfiguration = other.flexConsumptionConfiguration();
        return !(this$flexConsumptionConfiguration == null ? other$flexConsumptionConfiguration != null : !((Object)this$flexConsumptionConfiguration).equals(other$flexConsumptionConfiguration));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionAppConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enableDistributedTracing = this.enableDistributedTracing();
        result = result * 59 + ($enableDistributedTracing == null ? 43 : ((Object)$enableDistributedTracing).hashCode());
        Boolean $skipEndOfLifeValidation = this.skipEndOfLifeValidation();
        result = result * 59 + ($skipEndOfLifeValidation == null ? 43 : ((Object)$skipEndOfLifeValidation).hashCode());
        String $storageAccountName = this.storageAccountName();
        result = result * 59 + ($storageAccountName == null ? 43 : $storageAccountName.hashCode());
        String $storageAccountResourceGroup = this.storageAccountResourceGroup();
        result = result * 59 + ($storageAccountResourceGroup == null ? 43 : $storageAccountResourceGroup.hashCode());
        String $environment = this.environment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        ContainerAppsEnvironmentDraft.Config $environmentConfig = this.environmentConfig();
        result = result * 59 + ($environmentConfig == null ? 43 : $environmentConfig.hashCode());
        ContainerAppFunctionConfiguration $containerConfiguration = this.containerConfiguration();
        result = result * 59 + ($containerConfiguration == null ? 43 : ((Object)$containerConfiguration).hashCode());
        LogAnalyticsWorkspaceConfig $workspaceConfig = this.workspaceConfig();
        result = result * 59 + ($workspaceConfig == null ? 43 : $workspaceConfig.hashCode());
        ApplicationInsightsConfig $applicationInsightsConfig = this.applicationInsightsConfig();
        result = result * 59 + ($applicationInsightsConfig == null ? 43 : $applicationInsightsConfig.hashCode());
        FlexConsumptionConfiguration $flexConsumptionConfiguration = this.flexConsumptionConfiguration();
        result = result * 59 + ($flexConsumptionConfiguration == null ? 43 : ((Object)$flexConsumptionConfiguration).hashCode());
        return result;
    }

    @Generated
    public static abstract class FunctionAppConfigBuilder<C extends FunctionAppConfig, B extends FunctionAppConfigBuilder<C, B>>
    extends AppServiceConfig.AppServiceConfigBuilder<C, B> {
        @Generated
        private String storageAccountName;
        @Generated
        private String storageAccountResourceGroup;
        @Generated
        private String environment;
        @Generated
        private ContainerAppsEnvironmentDraft.Config environmentConfig;
        @Generated
        private ContainerAppFunctionConfiguration containerConfiguration;
        @Generated
        private LogAnalyticsWorkspaceConfig workspaceConfig;
        @Generated
        private Boolean enableDistributedTracing;
        @Generated
        private ApplicationInsightsConfig applicationInsightsConfig;
        @Generated
        private FlexConsumptionConfiguration flexConsumptionConfiguration;
        @Generated
        private boolean skipEndOfLifeValidation$set;
        @Generated
        private Boolean skipEndOfLifeValidation$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FunctionAppConfigBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FunctionAppConfig instance, FunctionAppConfigBuilder<?, ?> b) {
            b.storageAccountName(instance.storageAccountName);
            b.storageAccountResourceGroup(instance.storageAccountResourceGroup);
            b.environment(instance.environment);
            b.environmentConfig(instance.environmentConfig);
            b.containerConfiguration(instance.containerConfiguration);
            b.workspaceConfig(instance.workspaceConfig);
            b.enableDistributedTracing(instance.enableDistributedTracing);
            b.applicationInsightsConfig(instance.applicationInsightsConfig);
            b.flexConsumptionConfiguration(instance.flexConsumptionConfiguration);
            b.skipEndOfLifeValidation(instance.skipEndOfLifeValidation);
        }

        @Generated
        public B storageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return (B)this.self();
        }

        @Generated
        public B storageAccountResourceGroup(String storageAccountResourceGroup) {
            this.storageAccountResourceGroup = storageAccountResourceGroup;
            return (B)this.self();
        }

        @Generated
        public B environment(String environment) {
            this.environment = environment;
            return (B)this.self();
        }

        @Generated
        public B environmentConfig(ContainerAppsEnvironmentDraft.Config environmentConfig) {
            this.environmentConfig = environmentConfig;
            return (B)this.self();
        }

        @Generated
        public B containerConfiguration(ContainerAppFunctionConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return (B)this.self();
        }

        @Generated
        public B workspaceConfig(LogAnalyticsWorkspaceConfig workspaceConfig) {
            this.workspaceConfig = workspaceConfig;
            return (B)this.self();
        }

        @Generated
        public B enableDistributedTracing(Boolean enableDistributedTracing) {
            this.enableDistributedTracing = enableDistributedTracing;
            return (B)this.self();
        }

        @Generated
        public B applicationInsightsConfig(ApplicationInsightsConfig applicationInsightsConfig) {
            this.applicationInsightsConfig = applicationInsightsConfig;
            return (B)this.self();
        }

        @Generated
        public B flexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
            this.flexConsumptionConfiguration = flexConsumptionConfiguration;
            return (B)this.self();
        }

        @Generated
        public B skipEndOfLifeValidation(Boolean skipEndOfLifeValidation) {
            this.skipEndOfLifeValidation$value = skipEndOfLifeValidation;
            this.skipEndOfLifeValidation$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FunctionAppConfig.FunctionAppConfigBuilder(super=" + super.toString() + ", storageAccountName=" + this.storageAccountName + ", storageAccountResourceGroup=" + this.storageAccountResourceGroup + ", environment=" + this.environment + ", environmentConfig=" + this.environmentConfig + ", containerConfiguration=" + this.containerConfiguration + ", workspaceConfig=" + this.workspaceConfig + ", enableDistributedTracing=" + this.enableDistributedTracing + ", applicationInsightsConfig=" + this.applicationInsightsConfig + ", flexConsumptionConfiguration=" + this.flexConsumptionConfiguration + ", skipEndOfLifeValidation$value=" + this.skipEndOfLifeValidation$value + ")";
        }
    }

    @Generated
    private static final class FunctionAppConfigBuilderImpl
    extends FunctionAppConfigBuilder<FunctionAppConfig, FunctionAppConfigBuilderImpl> {
        @Generated
        private FunctionAppConfigBuilderImpl() {
        }

        @Override
        @Generated
        protected FunctionAppConfigBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FunctionAppConfig build() {
            return new FunctionAppConfig(this);
        }
    }
}

