/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.appservice.model.CsmDeploymentStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployOptions;
import com.microsoft.azure.toolkit.lib.appservice.model.DeploymentBuildStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.ErrorEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.StreamingLogTask;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.io.PrintStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DeployWebAppTask
extends AzureTask<WebAppBase<?, ?, ?>> {
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker webapp, you can navigate to %s to access your docker webapp.";
    private static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    private static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    private static final String START_APP = "Starting Web App after deploying artifacts...";
    private static final String START_APP_DONE = "Successfully started Web App.";
    private static final int DEFAULT_DEPLOYMENT_STATUS_REFRESH_INTERVAL = 5;
    private static final int DEFAULT_DEPLOYMENT_STATUS_MAX_REFRESH_TIMES = 30;
    private static final int DEPLOYMENT_STATUS_DISPLAY_REFRESH_INTERVAL = 500;
    private static final String CLEAR_MESSAGE_STRING;
    private final WebAppBase<?, ?, ?> webApp;
    private final List<WebAppArtifact> artifacts;
    private final boolean restartSite;
    private final boolean openStreamingLogOnFailure;
    private final Boolean waitDeploymentComplete;
    private final IAzureMessager messager;
    private final AtomicReference<KuduDeploymentResult> deploymentResultAtomicReference = new AtomicReference();
    private long deploymentStatusRefreshInterval = 5L;
    private long deploymentStatusMaxRefreshTimes = 30L;
    private PrintStream deploymentStatusStream;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts) {
        this(webApp, artifacts, false);
    }

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts, boolean restartSite) {
        this(webApp, artifacts, restartSite, null, false);
    }

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts, boolean restartSite, Boolean waitDeploymentComplete, boolean openStreamingLogOnFailure) {
        this.webApp = webApp;
        this.artifacts = artifacts;
        this.restartSite = restartSite;
        this.waitDeploymentComplete = waitDeploymentComplete;
        this.openStreamingLogOnFailure = openStreamingLogOnFailure;
        this.messager = AzureMessager.getMessager();
    }

    @AzureOperation(name="internal/webapp.deploy_app.app", params={"this.webApp.getName()"})
    public WebAppBase<?, ?, ?> doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            WebAppBase<?, ?, ?> webAppBase;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (Objects.requireNonNull(this.webApp.getRuntime()).isDocker()) {
                this.messager.info(AzureString.format((String)SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE, (Object[])new Object[]{"https://" + this.webApp.getHostName()}));
                webAppBase = this.webApp;
            } else {
                this.messager.info(String.format(DEPLOY_START, this.webApp.getName()));
                this.deployArtifacts();
                DeployWebAppTask.startAppService(this.webApp);
                webAppBase = this.webApp;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppBase;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void deployArtifacts() {
        if (this.artifacts.stream().anyMatch(artifact -> artifact.getDeployType() == null)) {
            throw new AzureToolkitRuntimeException("missing deployment type for some artifacts.");
        }
        OperationContext.action().setTelemetryProperty("subscriptionId", this.webApp.getSubscriptionId());
        OperationContext.action().setTelemetryProperty("deployToSlot", String.valueOf(this.webApp instanceof WebAppDeploymentSlot));
        Optional.ofNullable(this.webApp.getRuntime()).ifPresent(runtime -> OperationContext.action().setTelemetryProperty("runtime", runtime.getDisplayName()));
        Optional.ofNullable(this.webApp.getRuntime()).map(Runtime::getOperatingSystem).ifPresent(os -> OperationContext.action().setTelemetryProperty("os", os.getValue()));
        Optional.ofNullable(this.webApp.getRuntime()).map(Runtime::getJavaVersionUserText).ifPresent(javaVersion -> OperationContext.action().setTelemetryProperty("javaVersion", javaVersion));
        Optional.ofNullable(this.webApp.getRuntime()).map(WebAppRuntime::getContainerUserText).ifPresent(webContainer -> OperationContext.action().setTelemetryProperty("webContainer", webContainer));
        Optional.ofNullable(this.webApp.getAppServicePlan()).map(AppServicePlan::getPricingTier).ifPresent(pricingTier -> OperationContext.action().setTelemetryProperty("pricingTier", pricingTier.getSize()));
        long startTime = System.currentTimeMillis();
        List<WebAppArtifact> artifactsOneDeploy = this.artifacts.stream().filter(artifact -> artifact.getDeployType() != null).collect(Collectors.toList());
        boolean trackDeploymentStatus = this.isTrackDeploymentStatus();
        if (trackDeploymentStatus) {
            artifactsOneDeploy.forEach(resource -> this.deploymentResultAtomicReference.set(this.webApp.pushDeploy(resource.getDeployType(), resource.getFile(), DeployOptions.builder().path(resource.getPath()).restartSite(this.restartSite).trackDeployment(true).build())));
        } else {
            artifactsOneDeploy.forEach(resource -> this.webApp.deploy(resource.getDeployType(), resource.getFile(), DeployOptions.builder().path(resource.getPath()).restartSite(this.restartSite).build()));
        }
        if (!this.waitUntilDeploymentReady(trackDeploymentStatus, this.deploymentStatusRefreshInterval, this.deploymentStatusMaxRefreshTimes) && this.openStreamingLogOnFailure) {
            new StreamingLogTask(this.webApp).doExecute();
        }
        OperationContext.action().setTelemetryProperty("deploy-cost", String.valueOf(System.currentTimeMillis() - startTime));
    }

    public boolean waitUntilDeploymentReady(boolean trackDeploymentStatus, long deploymentStatusRefreshInterval, long deploymentStatusMaxRefreshTimes) {
        String trackId = Optional.ofNullable(this.deploymentResultAtomicReference.get()).map(KuduDeploymentResult::getDeploymentId).orElse(null);
        if (!trackDeploymentStatus || StringUtils.isBlank((CharSequence)trackId)) {
            return false;
        }
        AtomicReference<Object> status = new AtomicReference<Object>(null);
        Timer timer = Objects.isNull(this.deploymentStatusStream) ? null : new Timer();
        Optional.ofNullable(timer).ifPresent(t -> t.schedule((TimerTask)new TrackDeploymentStatusTask(status), 0L, 500L));
        CsmDeploymentStatus result = (CsmDeploymentStatus)Mono.fromCallable(() -> {
            CsmDeploymentStatus deploymentStatus = this.webApp.getDeploymentStatus(trackId);
            status.set(deploymentStatus);
            return deploymentStatus;
        }).delayElement(Duration.ofSeconds(deploymentStatusRefreshInterval)).subscribeOn(Schedulers.boundedElastic()).repeat(deploymentStatusMaxRefreshTimes).takeUntil(csmDeploymentStatus -> !csmDeploymentStatus.getStatus().isRunning()).blockLast();
        Optional.ofNullable(timer).ifPresent(Timer::cancel);
        DeploymentBuildStatus buildStatus = Optional.ofNullable(result).map(CsmDeploymentStatus::getStatus).orElse(null);
        if (buildStatus == null || buildStatus.isSucceed()) {
            return true;
        }
        if (buildStatus.isTimeout()) {
            AzureMessager.getMessager().warning("Resource deployed, but failed to get the deployment status as timeout");
        } else if (buildStatus.isRunning()) {
            AzureMessager.getMessager().warning("Resource deployed, but the deployment is still in process in Azure");
        } else if (buildStatus.isFailed()) {
            String errorMessages = CollectionUtils.isNotEmpty(result.getErrors()) ? result.getErrors().stream().map(ErrorEntity::getMessage).collect(Collectors.joining("\n")) : "";
            String failedInstancesLogs = CollectionUtils.isEmpty(result.getFailedInstancesLogs()) ? StringUtils.join(result.getFailedInstancesLogs(), (String)"\n") : "";
            throw new AzureToolkitRuntimeException(String.format("Failed to start app %s. %s %s", this.webApp.getName(), errorMessages, failedInstancesLogs));
        }
        return false;
    }

    private boolean isTrackDeploymentStatus() {
        if (BooleanUtils.isTrue((Boolean)this.waitDeploymentComplete) && this.webApp.getFormalStatus().isStopped()) {
            this.messager.info("Skip waiting deployment status for stopped web app.");
            return false;
        }
        if (BooleanUtils.isTrue((Boolean)this.waitDeploymentComplete) && Objects.requireNonNull(this.webApp.getRuntime()).isWindows()) {
            this.messager.warning("`waitDeploymentComplete` is not supported in Windows runtime, skip waiting for deployment status.");
            return false;
        }
        return Optional.ofNullable(this.waitDeploymentComplete).orElse(Objects.requireNonNull(this.webApp.getRuntime()).isLinux());
    }

    private static void startAppService(WebAppBase<?, ?, ?> target) {
        if (!target.getFormalStatus().isRunning()) {
            AzureMessager.getMessager().info(START_APP);
            target.start();
            AzureMessager.getMessager().info(START_APP_DONE);
        }
    }

    public void setDeploymentStatusRefreshInterval(long deploymentStatusRefreshInterval) {
        this.deploymentStatusRefreshInterval = deploymentStatusRefreshInterval;
    }

    public void setDeploymentStatusMaxRefreshTimes(long deploymentStatusMaxRefreshTimes) {
        this.deploymentStatusMaxRefreshTimes = deploymentStatusMaxRefreshTimes;
    }

    public void setDeploymentStatusStream(PrintStream deploymentStatusStream) {
        this.deploymentStatusStream = deploymentStatusStream;
    }

    static {
        DeployWebAppTask.ajc$preClinit();
        CLEAR_MESSAGE_STRING = StringUtils.repeat((String)" ", (int)100) + "\r";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployWebAppTask.java", DeployWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase"), 93);
    }

    private class TrackDeploymentStatusTask
    extends TimerTask {
        private final AtomicReference<CsmDeploymentStatus> status;
        private final AtomicInteger times = new AtomicInteger(0);

        @Override
        public void run() {
            StringBuilder message = new StringBuilder(this.getDeploymentStatus(this.status.get()));
            int dotTimes = this.times.addAndGet(1) % 4;
            IntStream.range(0, dotTimes).forEach(i -> message.append("."));
            IntStream.range(dotTimes, 4).forEach(i -> message.append(" "));
            this.printMessage(message.toString());
        }

        private void printMessage(String message) {
            if (Objects.isNull(DeployWebAppTask.this.deploymentStatusStream)) {
                return;
            }
            DeployWebAppTask.this.deploymentStatusStream.print(CLEAR_MESSAGE_STRING);
            DeployWebAppTask.this.deploymentStatusStream.print(message);
            DeployWebAppTask.this.deploymentStatusStream.print('\r');
            DeployWebAppTask.this.deploymentStatusStream.flush();
        }

        private String getDeploymentStatus(CsmDeploymentStatus deploymentStatus) {
            if (Objects.isNull(deploymentStatus)) {
                return "Waiting for deployment";
            }
            StringBuilder message = new StringBuilder(128);
            message.append(String.format("Status %s ", deploymentStatus.getStatus().getValue()));
            int totalInstanceCount = deploymentStatus.getTotalInstanceCount();
            if (totalInstanceCount > 0) {
                String instanceStatus = deploymentStatus.getNumberOfInstancesFailed() == 0 ? String.format("(%d/%d)", deploymentStatus.getNumberOfInstancesSuccessful(), totalInstanceCount) : String.format("(%d/%d, failed %d)", deploymentStatus.getNumberOfInstancesSuccessful(), totalInstanceCount, deploymentStatus.getNumberOfInstancesFailed());
                message.append(instanceStatus);
            }
            return message.toString();
        }

        public TrackDeploymentStatusTask(AtomicReference<CsmDeploymentStatus> status) {
            this.status = status;
        }
    }
}

