/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.common.model.ExpandableParameter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PricingTier
implements ExpandableParameter {
    public static final PricingTier BASIC_B1 = new PricingTier("Basic", "B1");
    public static final PricingTier BASIC_B2 = new PricingTier("Basic", "B2");
    public static final PricingTier BASIC_B3 = new PricingTier("Basic", "B3");
    public static final PricingTier STANDARD_S1 = new PricingTier("Standard", "S1");
    public static final PricingTier STANDARD_S2 = new PricingTier("Standard", "S2");
    public static final PricingTier STANDARD_S3 = new PricingTier("Standard", "S3");
    public static final PricingTier PREMIUM_P1 = new PricingTier("Premium", "P1");
    public static final PricingTier PREMIUM_P2 = new PricingTier("Premium", "P2");
    public static final PricingTier PREMIUM_P3 = new PricingTier("Premium", "P3");
    public static final PricingTier PREMIUM_P1V2 = new PricingTier("PremiumV2", "P1v2");
    public static final PricingTier PREMIUM_P2V2 = new PricingTier("PremiumV2", "P2v2");
    public static final PricingTier PREMIUM_P3V2 = new PricingTier("PremiumV2", "P3v2");
    public static final PricingTier PREMIUM_P1V3 = new PricingTier("PremiumV3", "P1v3");
    public static final PricingTier PREMIUM_P2V3 = new PricingTier("PremiumV3", "P2v3");
    public static final PricingTier PREMIUM_P3V3 = new PricingTier("PremiumV3", "P3v3");
    public static final PricingTier FREE_F1 = new PricingTier("Free", "F1");
    public static final PricingTier SHARED_D1 = new PricingTier("Shared", "D1");
    public static final PricingTier CONSUMPTION = new PricingTier("Dynamic", "Y1");
    public static final PricingTier FLEX_CONSUMPTION = new PricingTier("FlexConsumption", "FC1");
    public static final PricingTier ELASTIC_PREMIUM_EP1 = new PricingTier("ElasticPremium", "EP1");
    public static final PricingTier ELASTIC_PREMIUM_EP2 = new PricingTier("ElasticPremium", "EP2");
    public static final PricingTier ELASTIC_PREMIUM_EP3 = new PricingTier("ElasticPremium", "EP3");
    public static final Set<PricingTier> SHARED_PRICING = Collections.unmodifiableSet(Sets.newHashSet((Object[])new PricingTier[]{BASIC_B1, BASIC_B2, BASIC_B3, STANDARD_S1, STANDARD_S2, STANDARD_S3, PREMIUM_P1, PREMIUM_P2, PREMIUM_P3, PREMIUM_P1V2, PREMIUM_P2V2, PREMIUM_P3V2, PREMIUM_P1V3, PREMIUM_P2V3, PREMIUM_P3V3, FREE_F1, SHARED_D1}));
    public static final Set<PricingTier> WEB_APP_PRICING = Collections.unmodifiableSet(SHARED_PRICING);
    public static final Set<PricingTier> FUNCTION_PRICING = Collections.unmodifiableSet(SetUtils.union(SHARED_PRICING, (Set)Sets.newHashSet((Object[])new PricingTier[]{CONSUMPTION, FLEX_CONSUMPTION, ELASTIC_PREMIUM_EP1, ELASTIC_PREMIUM_EP2, ELASTIC_PREMIUM_EP3})));
    private static final Set<PricingTier> values = Collections.unmodifiableSet(SetUtils.union(WEB_APP_PRICING, FUNCTION_PRICING));
    private static final String CONSUMPTION_SIZE = "consumption";
    private static final String FLEX_CONSUMPTION_SIZE = "flex consumption";
    private String tier;
    private String size;

    public static Set<PricingTier> values() {
        return values;
    }

    public static PricingTier fromString(@Nonnull String size) {
        return PricingTier.fromString(null, size);
    }

    public static PricingTier fromString(@Nullable String tier, @Nonnull String size) {
        if (StringUtils.equalsIgnoreCase((CharSequence)CONSUMPTION_SIZE, (CharSequence)size)) {
            return CONSUMPTION;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)FLEX_CONSUMPTION_SIZE, (CharSequence)size)) {
            return FLEX_CONSUMPTION;
        }
        return PricingTier.values().stream().filter(pricingTier -> StringUtils.equalsIgnoreCase((CharSequence)size, (CharSequence)pricingTier.size) && (StringUtils.isEmpty((CharSequence)tier) || StringUtils.equals((CharSequence)tier, (CharSequence)pricingTier.tier))).findFirst().orElseGet(() -> new PricingTier(tier, size));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PricingTier)) {
            return false;
        }
        PricingTier current = PricingTier.fromString(this.tier, this.size);
        PricingTier target = PricingTier.fromString(((PricingTier)o).tier, ((PricingTier)o).size);
        return StringUtils.equalsIgnoreCase((CharSequence)current.tier, (CharSequence)target.tier) && StringUtils.equalsIgnoreCase((CharSequence)current.size, (CharSequence)target.size);
    }

    public int hashCode() {
        return Objects.hash(this.tier, this.size);
    }

    public String toString() {
        if (this.equals(CONSUMPTION)) {
            return "Consumption";
        }
        if (this.equals(FLEX_CONSUMPTION)) {
            return "Flex Consumption";
        }
        return this.getSize();
    }

    public boolean isConsumption() {
        return Objects.equals(this, CONSUMPTION);
    }

    public boolean isFlexConsumption() {
        return Objects.equals(this, FLEX_CONSUMPTION);
    }

    public boolean isExpandedValue() {
        return !PricingTier.values().contains(this);
    }

    public String getTier() {
        return this.tier;
    }

    public String getSize() {
        return this.size;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public PricingTier() {
    }

    public PricingTier(String tier, String size) {
        this.tier = tier;
        this.size = size;
    }
}

