/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.config;

import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppWindowsRuntime;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class RuntimeConfig {
    private OperatingSystem os;
    private String javaVersion;
    private String webContainer;
    private String image;
    private String registryUrl;
    private String username;
    private String password;
    private String startUpCommand;

    public static RuntimeConfig fromRuntime(@Nonnull Runtime runtime) {
        RuntimeConfig result = new RuntimeConfig();
        result.os(runtime.getOperatingSystem());
        result.javaVersion(runtime.getJavaVersionUserText());
        Optional.of(runtime).filter(WebAppRuntime.class::isInstance).map(WebAppRuntime.class::cast).map(WebAppRuntime::getContainerUserText).ifPresent(result::webContainer);
        return result;
    }

    @Nonnull
    public static Runtime toWebAppRuntime(@Nonnull RuntimeConfig runtime) {
        if (OperatingSystem.DOCKER != runtime.os()) {
            WebAppRuntime webAppRuntime = runtime.os() == OperatingSystem.WINDOWS ? WebAppWindowsRuntime.fromContainerAndJavaVersionUserText(runtime.getWebContainer(), runtime.getJavaVersion()) : WebAppLinuxRuntime.fromContainerAndJavaVersionUserText(runtime.getWebContainer(), runtime.getJavaVersion());
            return Objects.requireNonNull(webAppRuntime, "Invalid runtime configuration.");
        }
        return WebAppDockerRuntime.INSTANCE;
    }

    @Nonnull
    public static Runtime toFunctionAppRuntime(@Nonnull RuntimeConfig runtime) {
        if (OperatingSystem.DOCKER != runtime.os()) {
            FunctionAppRuntime webAppRuntime = runtime.os() == OperatingSystem.WINDOWS ? FunctionAppWindowsRuntime.fromJavaVersionUserText(runtime.getJavaVersion()) : FunctionAppLinuxRuntime.fromJavaVersionUserText(runtime.getJavaVersion());
            return Objects.requireNonNull(webAppRuntime, "Invalid runtime configuration.");
        }
        return FunctionAppDockerRuntime.INSTANCE;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getWebContainer() {
        return this.webContainer;
    }

    public String getImage() {
        return this.image;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getStartUpCommand() {
        return this.startUpCommand;
    }

    public void setOs(OperatingSystem os) {
        this.os = os;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setWebContainer(String webContainer) {
        this.webContainer = webContainer;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setStartUpCommand(String startUpCommand) {
        this.startUpCommand = startUpCommand;
    }

    public OperatingSystem os() {
        return this.os;
    }

    public String javaVersion() {
        return this.javaVersion;
    }

    public String webContainer() {
        return this.webContainer;
    }

    public String image() {
        return this.image;
    }

    public String registryUrl() {
        return this.registryUrl;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String startUpCommand() {
        return this.startUpCommand;
    }

    public RuntimeConfig os(OperatingSystem os) {
        this.os = os;
        return this;
    }

    public RuntimeConfig javaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    public RuntimeConfig webContainer(String webContainer) {
        this.webContainer = webContainer;
        return this;
    }

    public RuntimeConfig image(String image) {
        this.image = image;
        return this;
    }

    public RuntimeConfig registryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
        return this;
    }

    public RuntimeConfig username(String username) {
        this.username = username;
        return this;
    }

    public RuntimeConfig password(String password) {
        this.password = password;
        return this;
    }

    public RuntimeConfig startUpCommand(String startUpCommand) {
        this.startUpCommand = startUpCommand;
        return this;
    }

    public RuntimeConfig() {
    }

    public RuntimeConfig(OperatingSystem os, String javaVersion, String webContainer, String image, String registryUrl, String username, String password, String startUpCommand) {
        this.os = os;
        this.javaVersion = javaVersion;
        this.webContainer = webContainer;
        this.image = image;
        this.registryUrl = registryUrl;
        this.username = username;
        this.password = password;
        this.startUpCommand = startUpCommand;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeConfig)) {
            return false;
        }
        RuntimeConfig other = (RuntimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperatingSystem this$os = this.os();
        OperatingSystem other$os = other.os();
        if (this$os == null ? other$os != null : !((Object)((Object)this$os)).equals((Object)other$os)) {
            return false;
        }
        String this$javaVersion = this.javaVersion();
        String other$javaVersion = other.javaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
            return false;
        }
        String this$webContainer = this.webContainer();
        String other$webContainer = other.webContainer();
        if (this$webContainer == null ? other$webContainer != null : !this$webContainer.equals(other$webContainer)) {
            return false;
        }
        String this$image = this.image();
        String other$image = other.image();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$registryUrl = this.registryUrl();
        String other$registryUrl = other.registryUrl();
        if (this$registryUrl == null ? other$registryUrl != null : !this$registryUrl.equals(other$registryUrl)) {
            return false;
        }
        String this$username = this.username();
        String other$username = other.username();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.password();
        String other$password = other.password();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$startUpCommand = this.startUpCommand();
        String other$startUpCommand = other.startUpCommand();
        return !(this$startUpCommand == null ? other$startUpCommand != null : !this$startUpCommand.equals(other$startUpCommand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuntimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperatingSystem $os = this.os();
        result = result * 59 + ($os == null ? 43 : ((Object)((Object)$os)).hashCode());
        String $javaVersion = this.javaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
        String $webContainer = this.webContainer();
        result = result * 59 + ($webContainer == null ? 43 : $webContainer.hashCode());
        String $image = this.image();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $registryUrl = this.registryUrl();
        result = result * 59 + ($registryUrl == null ? 43 : $registryUrl.hashCode());
        String $username = this.username();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.password();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $startUpCommand = this.startUpCommand();
        result = result * 59 + ($startUpCommand == null ? 43 : $startUpCommand.hashCode());
        return result;
    }
}

